/* RecordType.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLListControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLListPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class RecordType extends XMLCollection {
	private Package myPackage = null;

	public RecordType(Package p) {
		super(null);
		setRequired(true);
		myPackage = p;
	}

	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		Member m = new Member(myPackage);
		m.setRequired(true);
		return m;
	}

	/**
	 * Creates panel which allows user to manipulate with instances of classes
	 * that makes a collection that this class represents. The panel consists of
	 * two sections: XMLListPanel - shows collections' elements, and
	 * XMLListControlPanel - display buttons for manipulating with that
	 * elements.
	 * <p>
	 * NOTE: The order of creation is relevant, first, the controlled panel must
	 * be created, and then the control panel
	 * 
	 * @return DTDPanel to be shown
	 */
	public XMLPanel getPanel() {
		controlledPanel = new XMLListPanel(this, "", false, true, false) {
			public boolean checkRequired() {
				if (isReadOnly || (refCollectionElements.size() > 0)) {
					return true;
				} else {
					XMLPanel
							.errorMessage(
									this.getDialog(),
									getOwner().toLabel(),
									"",
									XMLUtil
											.getLanguageDependentString("ErrorTheListMustContainAtLeastOneElement"));
					controlPanel.getComponent(1).requestFocus();
					return false;
				}
			}
		};
		controlPanel = new XMLListControlPanel(this, "", true, false, true);
		return new XMLGroupPanel(this, new XMLPanel[] { controlledPanel,
				controlPanel }, toLabel(), XMLPanel.BOX_LAYOUT, false, true);
	}

}
