/* ProcessHeader.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：XML元素的流程头信息类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.enums.command.CommonEnums;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTextPanel;
import com.ds.enums.EnumsUtil;

/**
 * Represents a WfMC DTD element that has the similar name. 流程头信息数据类
 * 
 * @see XML
 */
public class ProcessHeader extends XMLComplexElement {
    // 版本创建时间
    private Created refCreated = new Created(); // min=0

    // 流程描述
    private Description refDescription = new Description(true); // min=0

    // 版本时间限制
    private Limit refLimit = new Limit(); // min=0

    private XMLAttribute attrDurationUnit = new XMLAttribute(EnumsUtil.getAttribute(CommonEnums.DurationUnit));

    /**
     * Creates a new instance of the class.
     */
    public ProcessHeader() {
	super();

	fillStructure();
    }

    /**
     * Defines the super-class method. Read the explanation for this method within XMLComplexElement class.
     */
    protected void fillStructure() {
	complexStructure.add(attrDurationUnit);
	attributes.add(attrDurationUnit);
	complexStructure.add(refCreated);
	complexStructure.add(refDescription);
	complexStructure.add(refLimit);
    }

    public void fromXML(Node node) {
	attrDurationUnit.setValue("");
	refCreated.setValue("");
	super.fromXML(node);
    }

    // 验证元素填写的合法性
    public boolean isValidEnter(XMLPanel groupPanel) {
	XMLTextPanel p = (XMLTextPanel) ((XMLGroupPanel) groupPanel).getPanel(4);
	String value = p.getText();
	if (!Utils.isNumber(value)) {
	    XMLPanel.errorMessage(groupPanel.getDialog(), ResourceManager.getLanguageDependentString("Sys.ErrorMessage.dialogTitle"), p.getOwner().toLabel() + ResourceManager.getLanguageDependentString("Sys.Colon"),
		    ResourceManager.getLanguageDependentString("Sys.ErrorMessage.invalid"));
	    p.requestFocus();
	    return false;
	} else {
	    return true;
	}
    }

    // 实现clone方法
    public Object clone() {
	ProcessHeader ph = (ProcessHeader) super.clone();
	ph.attrDurationUnit = (XMLAttribute) this.attrDurationUnit.clone();
	ph.refCreated = (Created) this.refCreated.clone();
	ph.refCreated.setValue(XMLUtil.getCurrentDateAndTime());
	ph.refDescription = (Description) this.refDescription.clone();
	ph.refLimit = (Limit) this.refLimit.clone();
	ph.fillStructure();
	return ph;
    }
}
