/* ExtendedAttributes.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：XML元素的扩展属性集合类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.List;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTableControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLTablePanel;
import com.ds.common.util.XMLUtility;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * Represents a WfMC DTD element that has the similar name. This class is a
 * collection of class <b>ExtendedAttribute</b> instances.
 * 
 * @see XMLCollection
 */
public class ExtendedAttributes extends XMLCollection {
	/**
	 * Creates a new instance of the class.
	 * 
	 * @param myOwner
	 *            Could be any class derived from XMLComplexElement class (e.g.
	 *            Activity, Transition, Package, ...).
	 */
	public ExtendedAttributes(XMLComplexElement myOwner) {
		super(myOwner, "ExtendedAttributes");
		setLabelName(ResourceManager
				.getLanguageDependentString("ExtendedAttributes.display"));
	}

	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		ExtendedAttribute ea = new ExtendedAttribute(this);
		ea.setRequired(true);
		return ea;
	}

	/**
	 * 通过指定name得到相应的ExtendedAttribute
	 * 
	 * @param name
	 *            给定的name
	 * @return 满足条件的ExtendedAttribute
	 */
	public ExtendedAttribute getExtendedAttribute(String name) {
		return (ExtendedAttribute) super.getCollectionElement(name);
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		ExtendedAttributes eas = (ExtendedAttributes) super.clone();
		eas.myOwner = this.myOwner;
		return eas;
	}

	public int[] getInvisibleTableFieldOrdinals() {
		int[] itfo = new int[2];
		itfo[0] = 2;
		itfo[1] = 3;
		return itfo;
	}

	// First, the controlled panel must be created, and then the control panel
	public XMLPanel getPanel() {
		controlledPanel = new XMLTablePanel(this, "", false, false, true);
		controlPanel = new XMLTableControlPanel(this, "", true, false);
		return new XMLGroupPanel(this, new XMLPanel[] { controlledPanel,
				controlPanel }, toLabel(), XMLPanel.BOX_LAYOUT, false, true);
	}

	// 解析XPDL文件保存到扩展属性对象
	public void fromXML(Node node) {
		if (node != null) {
			List children = XMLUtility.getChildNodes(node, Node.ELEMENT_NODE);
			for (int i = 0; i < children.size(); i++) {
				Element child = (Element) children.get(i);
				String childName = child.getAttribute("Name");
				XMLElement ea = getExtendedAttribute(childName);
				if (ea == null) {
					ea = generateNewElement();
					refCollectionElements.add(ea);
				}
				ea.fromXML(child);
			}
		}
	}
}
