/* Content.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XMLSimpleElement;
import com.ds.bpm.bpd.xml.elements.specialpanels.XMLComplexContentPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * A helper element.
 */
public class ComplexContent extends XMLSimpleElement {
	private Package pkg;

	public ComplexContent(Package pkg) {
		super();
		this.pkg = pkg;
	}

	/**
	 * Prepares the panel for entering/reading description of some XML element.
	 * This panel alowes entering of multiple lines of text.
	 * 
	 * @return XMLPanel to be shown.
	 */
	public XMLPanel getPanel() {
		return new XMLComplexContentPanel(this, pkg);
	}
}
