/* Automatic.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class Automatic extends XMLComplexElement {
	/**
	 * Overrides super class method that returns XMLGroupPanel, to return the
	 * empty panel.
	 * 
	 * @return Empty panel - nothing to show.
	 */
	public XMLPanel getPanel() {
		return new XMLPanel();
	}

	/**
	 * Overrides super-class method to indicate that this element is never
	 * empty, so it's tag will always be written into XML file.
	 * 
	 * @return <tt>false</tt>
	 */
	public boolean isEmpty() {
		return false;
	}
}
