/* ActualParameters.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.specialpanels.XMLActualParametersListControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLListPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Represents a WfMC DTD element that has the similar name. This class is a
 * collection of class <b>ActualParameter</b> instances.
 * 
 * @see XML
 */
public class ActualParameters extends XMLCollection {
	/** Used to get data fields defined within workflow process */
	private transient WorkflowProcess myWorkflow = null;

	/**
	 * Creates a new instance of the class.
	 * 
	 * @param wp
	 *            The workflow process which defines DataField elements to use
	 *            as a actual parameters.
	 */
	public ActualParameters(WorkflowProcess wp) {
		super(null);
		myWorkflow = wp;
	}

	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		ActualParameter ap = new ActualParameter(myWorkflow);
		ap.setRequired(true);
		return ap;
	}

	/**
	 * Creates panel which allows user to manipulate with instances of classes
	 * that makes a collection that this class represents. The panel consists of
	 * two sections: XMLListPanel - shows collections' elements, and
	 * XMLListControlPanel - display buttons for manipulating with that
	 * elements.
	 * <p>
	 * NOTE: The order of creation is relevant, first, the controlled panel must
	 * be created, and then the control panel
	 * 
	 * @return DTDPanel to be shown
	 */
	public XMLPanel getPanel() {
		controlledPanel = new XMLListPanel(this, "", false, true, false);
		// controlPanel=new XMLListControlPanel(this,"",true,false,true);
		controlPanel = new XMLActualParametersListControlPanel(this, "", true,
				false);
		return new XMLGroupPanel(this, new XMLPanel[] { controlledPanel,
				controlPanel }, toLabel(), XMLPanel.BOX_LAYOUT, false, true);
	}

	/**
	 * Overrides the super class method to return the label for ActualParameter -
	 * thus means that it returns the string that is defined in property file
	 * for ActualParameterKey.
	 * 
	 * @return The word for ActualParameter in currently used language.
	 */
	public Object toValue() {
		return toLabel();
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		ActualParameters ap = (ActualParameters) super.clone();
		ap.myWorkflow = this.myWorkflow;
		return ap;
	}

}
