/* SubFlow.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：子流程活动XML元素类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.activity;

import java.rmi.RemoteException;
import java.util.List;
import java.util.Set;

import com.ds.bpm.enums.activitydef.ActivityDefEnums;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.WorkflowManager;
import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.Package;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.WorkflowProcesses;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.client.ProcessDef;
import com.ds.common.util.XMLUtility;
import com.ds.enums.EnumsUtil;

/**
 * Represents a WfMC DTD element that has the similar name. 子流程活动类
 * 
 * @see XML
 */
public class OutFlow extends XMLComplexElement {
    // 是否等待流程返回

    private XMLAttribute attrExecution = new XMLAttribute(EnumsUtil.getAttribute(ActivityDefEnums.Execution));

    private XMLAttribute outflow;

    private transient Package myPackage = null;

    private transient WorkflowProcess myWP = null;

    private transient Activity myAct = null;

    /**
     * Creates a new instance of the class.
     * 
     * @param act
     *            The activity that holds this element.
     * @throws RemoteException
     */
    public OutFlow(Activity act)  {
	super();

	// 初始化页面显示属性
	setLabelName(ResourceManager.getLanguageDependentString("Activity.General.Type.OutFlow.value"));

	attrExecution.setLabelName(ResourceManager.getLanguageDependentString("Activity.OutFlow.Execution.display"));

	if (WorkflowManager.getAllFlows() != null && WorkflowManager.getAllFlows().size() > 0) {
	    
	    List<ProcessDef> processDefs = WorkflowManager.getAllFlows();
	    String[][] arrs = new String[processDefs.size()][2];
	    int k = 0;
	    for (ProcessDef processDef : processDefs) {
		arrs[k][0] = processDef.getProcessDefId();
		arrs[k][1] = processDef.getName();
		k = k++;
	    }
	    
	    outflow = new XMLAttribute("Id", arrs, 0);

	    outflow.setLabelName(ResourceManager.getLanguageDependentString("Activity.OutFlow.OutFlowRef.display"));
	}

	myAct = act;
	if (myAct != null) {

	    myWP = myAct.getOwnerProcess();
	    myPackage = myWP.getPackage();
	    Set allExternalPackages = myPackage.getAllExternalPackages();
	}

	fillStructure();
    }

    public String getAttrId() {
	return (String) outflow.toValue();

    }

    /**
     * Defines the super-class method. Read the explanation for this method within XMLComplexElement class.
     */
    public void setAttrId(String subProcessId) {

	fillStructure();
	afterImporting();
    }

    protected void fillStructure() {

	complexStructure.add(attrExecution);
	complexStructure.add(outflow);
	attributes.add(attrExecution);
	attributes.add(outflow);
    }

    public Package getPackage() {
	return myPackage;
    }

    /**
     * Overrides super-class method to realize this class specific writting to XML file.
     */
    public void toXML(Node parent) throws DOMException {
	// When saving to file, setting ID to referenced workflow process ID
	// If workflow process is not referenced, value is already set to -1

	// complexStructure.remove(1);
	super.toXML(parent);

    }

    public void fromXML(Node node) {
	Node destNode = node;
	if (node.getNodeName().equals("Implementation")) {
	    destNode = XMLUtility.getFirstChild(node, Node.ELEMENT_NODE);
	}
	super.fromXML(destNode);
    }

    /**
     * Called after importing of XML file to set the proper WorkflowProcess object for subflow reference, and proper
     * DataField objects for ActualParameters references, according on it's IDs read from XML.
     */
    protected void afterImporting() {
	// setting choosen workflow process
	String wantedWpID = outflow.toValue().toString();

	WorkflowProcess wp = ((WorkflowProcesses) myPackage.get("WorkflowProcesses")).getWorkflowProcess(wantedWpID);

    }

    /**
     * Uses a trick to set the cloned instance of actual parameters to be edited, so that canceling of changes to the
     * actual parameter collection can be handled - the real instance of actual parameters is set to the cloned instance
     * within the isValidData method.
     */
    public XMLPanel getPanel() {
	XMLPanel p = new XMLGroupPanel(this, new XMLElement[] { outflow, attrExecution },
		// new XMLElement[] { helperElement, attrExecution,subflow },
		toLabel());
	return p;
    }

    /**
     * Used to create exact copy of instance of this class. The newly created instance will have all the properties same
     * as the copied one.
     * 
     * @return The newly created instance of this class.
     */
    public Object clone() {
	OutFlow s = (OutFlow) super.clone();

	s.outflow = (XMLAttribute) this.outflow.clone();
	s.attrExecution = (XMLAttribute) this.attrExecution.clone();

	s.myPackage = this.myPackage;
	s.myWP = this.myWP;

	s.fillStructure();
	// afterImporting();
	return s;
    }

    /**
     * Checks if actual and formal params are matched by type and number. This method is called only if user doesn't
     * press Cancel button within the dialog for editing Tool properties, so the changes to the real collection of
     * actual parameters are applied here.
     * 
     * @param groupPanel
     *            The panel for editing parameters.
     * @return <tt>true</tt> if actual and formal parameter types and number are matching, <tt>false</tt> otherwise.
     */
    public boolean isValidEnter(XMLPanel groupPanel) {
	return super.isValidEnter(groupPanel);
    }

}
