/* XMLCollectionElement.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：XML元素的集合元素类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml;

import com.ds.bpm.bpd.plugin.impl.activity.ActivityRight;
import com.ds.bpm.bpd.xml.activity.Activities;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.*;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.client.event.ActivityEvent;
import org.w3c.dom.Node;

import javax.swing.tree.DefaultMutableTreeNode;

/**
 * Represents an XML element that belongs to some collection. Such element always has the 'Id' attribute.
 */
public class XMLCollectionElement extends XMLComplexElement {

    public static final String ID_DELIMITER = "_";

    protected XMLAttribute attrId = new XMLAttribute("Id"); // required

    protected transient XMLCollection myCollection;

    // element by itself doesn't fill the structure - it is up
    // to extended classes to do it
    public XMLCollectionElement(XMLCollection myCollection) {
	super();

	this.myCollection = myCollection;
	try {
	    attrId.setValue(myCollection.generateID());
	} catch (Exception ex) {
	}
    }

    public String getID() {
	return attrId.value.toString();
    }

    public XMLCollection getCollection() {
	return myCollection;
    }

    protected void fillStructure() {
	attrId.setRequired(true);

	complexStructure.add(attrId);
	attributes.add(attrId);
    }

    public void fromXML(Node node) {
	super.fromXML(node);
	myCollection.updateID(getID());
    }

    public boolean isIDUniqueAndValid(XMLPanel p) {
	return true;
    }

    // I think that clone is not needed here because of constructor
    // add cloned attributes to attributes list
    public Object clone() {
	XMLCollectionElement d = (XMLCollectionElement) super.clone();
	d.attrId = (XMLAttribute) this.attrId.clone();
	d.myCollection = this.myCollection;
	return d;
    }

    public void setCollection(XMLCollection myCollection) {
	this.myCollection = myCollection;
    }

    /**
     * DefaultMutableTreeNode with all subnodes of this element.
     * 
     * @return return node with subelements.
     */
    public DefaultMutableTreeNode getNode() {
	DefaultMutableTreeNode node = new ToNameMutableTreeNode(this);
	for (int i = 0; i < this.complexStructure.size(); i++) {
	    if (!this.attributes.contains(this.complexStructure.get(i))) {
		DefaultMutableTreeNode xmdt = ((XMLElement) this.complexStructure.get(i)).getNode();
		Object object = xmdt.getUserObject();
		if (object instanceof Activity || object instanceof WorkflowProcess || object instanceof Activities || object instanceof ActivitySets || object instanceof ActivitySet || object instanceof Transitions
			|| object instanceof Transition || object instanceof ActivityEvent
			// || object instanceof ActivityForm
			|| object instanceof ActivityRight) {
		    node.add(xmdt);
		}
	    }
	}
	return node;
    }
}

/* End of XMLCollectionElement.java */
