/*
 * Created on 2004-1-6
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml;

import com.ds.bpm.bpd.xml.panels.XMLMultiLineTextButtonPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: XMLAttribute的扩展类，主要用于活动定义中办理人选择条件等属性设置
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-1-6 10:44:33
 * @version 1.0
 * @deprecated
 */
public class XMLButtonAttribute extends XMLAttribute {

	// 保存原有的对象值
	private String oldValue = "";

	// 标记对象值是否保存过
	private boolean isModified = false;

	// 工具提示
	private String toolTip = "";

	// 可供选择的数据
	private String[][] choices;

	/**
	 * 构造器
	 * 
	 * @param name
	 *            属性名称
	 */
	public XMLButtonAttribute(String name) {
		super(name);
	}

	public XMLPanel getPanel() {
		return new XMLMultiLineTextButtonPanel(this, true);
	}

	public String getOldValue() {
		return oldValue;
	}

	public void setOldValue(String oldValue) {
		this.oldValue = oldValue;
	}

	public boolean isModified() {
		return isModified;
	}

	public void setModified(boolean isModified) {
		this.isModified = isModified;
	}

	public void setToolTipText(String toolTip) {
		this.toolTip = toolTip;
	}

	public String getToolTipText() {
		return toolTip;
	}

	public void refreshDisplayValue() {
		setModified(true);
	}

	public void setDefaultChoices(String[][] choices) {
		this.choices = choices;
	}

	public String[][] getDefaultChoices() {
		return choices;
	}
}
