/* XMLButton.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml;

import java.awt.Dimension;
import java.awt.Insets;
import java.net.URL;

import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;

import com.ds.bpm.bpd.BPDConstants;
import com.ds.bpm.bpd.ResourceManager;

/**
 * An implementation of 'push' button that depending on parameters passed during
 * creation, sets proper button name, icon and dimension.
 */
public class XMLButton extends JButton {

	/**
	 * Creates 'push' button with specified attributes.
	 * 
	 * @param name
	 *            the name to be written on the button.
	 * @param keyToIcon
	 *            when an <i>imageSuffix</i> is added to this keyword, it
	 *            presents the resource path keyword within property file. This
	 *            resource represents an image file.
	 * @param d
	 *            dimension of button.
	 */
	public XMLButton(String name, String keyToIcon, Dimension d) {

		super(name);

		URL u = ResourceManager.getResource(keyToIcon
				+ BPDConstants.IMAGE_SUFFIX);
		if (u != null) {
			setIcon(new ImageIcon(u));
		}

		setVerticalTextPosition(AbstractButton.CENTER);
		Insets i = getInsets();
		Dimension di = new Dimension(d);
		di.width = di.width + i.left + i.right;
		di.height = di.height + i.top + i.bottom;

		setMinimumSize(new Dimension(di));
		setMaximumSize(new Dimension(di));
		setPreferredSize(new Dimension(di));
	}
}

/* End of XMLButton.java */
