
package com.ds.bpm.bpd.plugin.impl.route;

import com.ds.bpm.bpd.plugin.ExpressionElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.plugin.impl.activity.Message;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.Transition;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.formula.Formulas;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;
import com.ds.config.BPDPlugin;
import com.ds.esb.config.formula.FormulaType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.util.*;

public class RoutePlugin extends ExpressionElement {


    private Formulas rightSelected = new Formulas(this, FormulaType.ESDCOM);

    private Formulas actionSelected = new Formulas(this, FormulaType.ActionSelectedID);

    private Formulas dataSelected = new Formulas(this, FormulaType.TableSelectedID);

    private Formulas webAPISelected = new Formulas(this, FormulaType.WebAPISelectedID);

    public RoutePlugin(BPDPlugin plugin) {
        super(plugin);
        fillStructure();
    }

    public WorkflowProcess getProcess() {
        return wp;
    }

    protected void fillStructure() {
        super.fillStructure();
    }

    // 把活动办理权限信息保存在XML文件中
    public void toXML(Node parent) {
        NodeList nodeList = ((Element) parent).getElementsByTagName("ExtendedAttributes");
        Element easElem;
        Document doc = parent.getOwnerDocument();
        if (nodeList.getLength() != 0) {
            easElem = (Element) nodeList.item(0);
        } else {
            easElem = doc.createElement("ExtendedAttributes");
            parent.appendChild(easElem);
        }

        for (Iterator iter = complexStructure.iterator(); iter.hasNext(); ) {
            XMLElement element = (XMLElement) iter.next();
            if (element instanceof Formulas) {
                element.toXML(easElem);
            } else {
                Element eaElem = doc.createElement("ExtendedAttribute");
                eaElem.setAttribute("Name", element.toName());
                eaElem.setAttribute("Value", element.toValue().toString());
                easElem.appendChild(eaElem);
            }
        }

    }


    public XMLAttribute getXMLAttributeByName(String name) {

        Iterator it = complexStructure.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof XMLAttribute) {
                XMLAttribute att = (XMLAttribute) obj;
                if (name.equalsIgnoreCase(att.toKey().toString())) {
                    return att;
                }
            }
        }

        return null;

    }

    // 从活动扩展属性保存到活动权限对象
    public void afterImporting() throws PluginException {
        Object obj = getProperty("Route");
        if (obj == null) {
            throw new PluginException(Message.getLanguageDependentString("Plugin.Initialize.Error"));
        }
        route = (Transition) obj;
        ExtendedAttributes exAttrs = (ExtendedAttributes) route.get("ExtendedAttributes");
        Set easToRemove = new HashSet();
        Iterator it = exAttrs.toCollection().iterator();
        String nm = "";
        String val = "";

        List rightSelectedList = new ArrayList();
        List actionSelectedList = new ArrayList();
        List dataSelectedList = new ArrayList();
        List apiSelectedList = new ArrayList();

        while (it.hasNext()) {
            ExtendedAttribute ea = (ExtendedAttribute) it.next();
            nm = ea.get("Name").toValue().toString();
            val = ea.get("Value").toValue().toString();
            if (nm.startsWith(FormulaType.ESDCOM.getType())) {
                rightSelectedList.add(ea);
                easToRemove.add(ea);
                continue;
            }

            if (nm.startsWith(FormulaType.ActionSelectedID.getType())) {
                actionSelectedList.add(ea);
                easToRemove.add(ea);
                continue;
            }

            if (nm.startsWith(FormulaType.TableSelectedID.getType())) {
                dataSelectedList.add(ea);
                easToRemove.add(ea);
                continue;
            }

            if (nm.startsWith(FormulaType.WebAPISelectedID.getType())) {
                apiSelectedList.add(ea);
                easToRemove.add(ea);
                continue;
            }

            XMLAttribute attribute = this.getXMLAttributeByName(nm);
            if (attribute != null) {
                attribute.setValue(val);
                attribute.refreshDisplayValue();
                easToRemove.add(ea);
                continue;
            }

        }


        rightSelected.afterImporting(rightSelectedList);
        actionSelected.afterImporting(actionSelectedList);
        dataSelected.afterImporting(dataSelectedList);
        webAPISelected.afterImporting(apiSelectedList);
        exAttrs.toCollection().removeAll(easToRemove);
    }

    public void setLabelName() {
        // 初始化页面显示属性
        setLabelName(this.getBpdElement().getDisplayname());
    }

    public Object clone() {
        RoutePlugin ar = (RoutePlugin) super.clone();
        ar.rightSelected = (Formulas) this.rightSelected.clone();
        ar.actionSelected = (Formulas) this.actionSelected.clone();
        ar.dataSelected = (Formulas) this.dataSelected.clone();

        ar.fillStructure();
        return ar;
    }

    public XMLPanel getPanel() {
        return new XMLTabbedPanel(this, new XMLPanel[]{actionSelected.getPanel(), rightSelected.getPanel(), dataSelected.getPanel(), webAPISelected.getPanel()});
    }
}
