/*
 * Created on 2004-2-23
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.process;

import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.XMLTablePanel;

import javax.swing.*;


public class XMLProcessTablePanel extends XMLTablePanel {

    /**
     * Constructs XMLProcessFormPanel
     *
     * @param myOwner
     * @param title
     * @param hasBorder
     * @param automaticWidth
     */
    public XMLProcessTablePanel(XMLCollection myOwner, String title,
                                boolean hasBorder, boolean automaticWidth) {
        super(myOwner, title, hasBorder, automaticWidth);
    }

    protected void editElementDialog() {

        XMLComplexElement editElement = getSelectedElement();
        if (editElement != null) {
            XMLElementDialog de = new XMLElementDialog(getDialog(), editElement
                    .toLabel()
                    + " - " + XMLUtil.getLanguageDependentString("EditingKey"));
            de.editXMLElement(editElement.getPanel(), true, false);
            if (!de.isCanceled()) {
                modifyElement(editElement);
                ((XMLCollection) getOwner()).onElementModified(editElement);
            }
        } else {
            JOptionPane
                    .showMessageDialog(
                            getDialog(),
                            XMLUtil
                                    .getLanguageDependentString("WarningEmptySelectionToEditOrDelete"),
                            XMLUtil.getLanguageDependentString("Title"),
                            JOptionPane.WARNING_MESSAGE);
        }
        getTable().requestFocus();
    }
}
