/*
 * Created on 2004-2-23
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.commonattribut;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLUtil;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 配置属性消息类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-2-23 1:06:04
 * @version 1.0
 */
public class Message {
	private static Locale defaultLocale;

	private static ResourceBundle defaultResourceBundle;

	private static Locale choosenLocale;

	private static ResourceBundle choosenResourceBundle;

	// 字符编码字符串
	private static String encode = "GB2312";

	// The path of Resource File
	private static String rsFile = "com.ds.bpm.bpd.plugin.impl.common.commonplugin";

	private static String oldRsFile = rsFile;

	private static boolean bInvalid = true;

	private static void load() {
		if (bInvalid) {
			bInvalid = false;
			try {
				// default is english
				defaultLocale = new Locale("");
				defaultResourceBundle = ResourceBundle.getBundle(rsFile,
						defaultLocale);

				// chose the default system settings at the start
				String startingLocale = BPDConfig.getInstance()
						.getStartingLocale();
				if (startingLocale != null && startingLocale.length() > 0) {
					if (!startingLocale.equals("default")) {
						choosenLocale = new Locale(startingLocale);
					} else {
						choosenLocale = defaultLocale;
					}
				} else {
					choosenLocale = Locale.getDefault();
				}
				if (!startingLocale.equals("default")) {
					choosenResourceBundle = ResourceBundle.getBundle(rsFile,
							choosenLocale);
				} else {
					choosenResourceBundle = defaultResourceBundle;
				}
				setChoosen(ResourceManager.getChoosenLocale());
			} catch (MissingResourceException mre) {
				System.err.println(rsFile + ".properties not found");
				System.exit(1);
			}
		}
	}

	/**
	 * Gets a language dependent string from the resource bundle.
	 * <p>
	 * Resource bundle represents the <i>property file</i>. For example, if
	 * property file contains something like this:<BR>
	 * <CENTER>menubar=file edit help</CENTER> method call
	 * getLanguageDependentString("menubar") will give the string <i>file edit
	 * help</i> as a result. <BR>
	 * This method reads information from property file. If can't find desired
	 * resource, returns <b>null</b>.
	 * 
	 * @param nm
	 *            name of the resource to fetch.
	 * @return String value of named resource.
	 */
	public static String getLanguageDependentString(String nm) {
		load();
		String str;
		try {
			str = getEncodeString(choosenResourceBundle.getString(nm), true);
		} catch (MissingResourceException mre) {
			try {
				str = defaultResourceBundle.getString(nm);
			} catch (MissingResourceException mre1) {
				str = null;
			}
		}
		return str;
	}

	/**
	 * Returns the default resource bundle.
	 */
	public static ResourceBundle getDefaultResourceBundle() {
		load();
		return defaultResourceBundle;
	}

	/**
	 * Returns the current locale.
	 */
	public static ResourceBundle getChoosenResourceBundle() {
		load();
		return choosenResourceBundle;
	}

	/**
	 * Returns the default locale.
	 */
	public static Locale getDefaultLocale() {
		return defaultLocale;
	}

	/**
	 * Returns the current locale.
	 */
	public static Locale getChoosenLocale() {
		return choosenLocale;
	}

	/**
	 * Sets the new resource and locale to be used.
	 */
	public static void setChoosen(Locale loc) throws MissingResourceException {
		load();
		Locale previousLocale = choosenLocale;
		try {
			choosenLocale = loc;
			choosenResourceBundle = ResourceBundle.getBundle(rsFile, loc);
			XMLUtil.setChoosenResources(choosenResourceBundle);
		} catch (Exception ex) {
			choosenLocale = previousLocale;
		}
	}

	/**
	 * Sets the encoding String of message
	 * 
	 * @param message
	 *            the name of string.
	 * @param isEncode
	 *            is or is not ecoding..
	 * @return encoding String value of message.
	 */
	public static String getEncodeString(String message, boolean isEncode) {
		// 返回字符串
		String str = "";
		if (isEncode) {
			// 通过字符编码后的返回字符串
			try {
				str = new String(message.getBytes("ISO8859-1"), encode);
			} catch (Exception ex) {
				ex.printStackTrace();
			}
		} else {
			// 不通过编码的返回字符串
			str = message;
		}
		return str;
	}

	public static void setResourceFile(String newRsFile) {
		oldRsFile = rsFile;
		rsFile = newRsFile;
		bInvalid = true;
	}

	public static void recoverResourceFile() {
		rsFile = oldRsFile;
		bInvalid = true;
	}

	public static String getEncode() {
		return encode;
	}

	public void setEncode(String encodingStr) {
		encode = encodingStr;
		bInvalid = true;
	}
}
