/*
 * Created on 2004-3-4
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.commonattribut;

import java.util.List;

import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.plugin.PluginElement;
import com.ds.bpm.bpd.plugin.impl.activity.Message;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: WebWord中可操作按钮
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-3-4 16:55:02
 * @version 1.0
 */
public class CommonAttributeTableButton extends XMLCollectionElement {

	// WebWordButton代码
	private XMLAttribute attrCode = new XMLAttribute("Code");

	// WebWordButton显示名称
	private XMLAttribute attrName = new XMLAttribute("Name");

	//是否可操作
	private XMLAttribute attrOperation = new XMLAttribute("Operation");

	// 标识标签
	private XMLAttribute attrLabel = new XMLAttribute("Label");

	
//	 插件类
	private PluginElement pe;
	/**
	 * Construct a WebWordButton instance.
	 * 
	 * @param myCollection
	 */
	public CommonAttributeTableButton(XMLCollection myCollection) {
		super(myCollection);
		
		pe = (PluginElement) getCollection().getOwner();
		
		// 初始化界面显示信息
		
	
		
	if (pe.getProperty("Button.Name.display") != null) {
			attrName.setLabelName((String) pe
					.getProperty("Button.Name.display"));
		} else {
			attrName
					.setLabelName(Message
							.getLanguageDependentString("Activity.CommonAttributeTable.Button.Name.display"));
		}
		if (pe.getProperty("Button.Operation.display") != null) {
			attrOperation.setLabelName((String) pe
					.getProperty("Button.Operation.display"));
		} else {
			attrOperation
					.setLabelName(Message
							.getLanguageDependentString("Activity.CommonAttributeTable.Button.Operation.display"));
		}
		fillStructure();
	}

	protected void fillStructure() {
		super.fillStructure();
		complexStructure.add(attrCode);
		complexStructure.add(attrName);
		complexStructure.add(attrOperation);
		complexStructure.add(attrLabel);
	}

	// 把扩展属性操作控制信息保存到XPDL
	public void toXML(Node parent) {
		Element elem = parent.getOwnerDocument().createElement(
				"ExtendedAttribute");
		String parentName = CommonAttributeTable.ATTACHMENT + "."
				+ attrCode.toValue().toString().toUpperCase();
		if (!Utils.isExtendedAttributeExisted(parent, parentName)) {
			elem.setAttribute("Name", parentName);
			elem.setAttribute("Type", CommonAttributeTable.APPLICATION_NAME);
			elem.setAttribute("Value", attrName.toValue().toString());
			parent.appendChild(elem);
		}
		String name = parentName + "." + attrLabel.toValue().toString();
		elem = parent.getOwnerDocument().createElement("ExtendedAttribute");
		elem.setAttribute("Name", name);
		elem.setAttribute("Type", CommonAttributeTable.APPLICATION_NAME);
		Object obj = attrOperation.toValue();
		String value = obj.toString();
		if (obj instanceof XMLSelectOption) {
			value = ((XMLSelectOption) obj).getText();
		} else {
			value = ((CommonAttributeTableButtons) getCollection()).getButtonValue(value);
		}
		if (!value.equals("")) {
			elem.setAttribute("Value", value);
			parent.appendChild(elem);
		}
	}

	// 实现clone方法
	public Object clone() {
		CommonAttributeTableButton wwb = (CommonAttributeTableButton) super.clone();
		wwb.attrCode = (XMLAttribute) this.attrCode.clone();
		wwb.attrName = (XMLAttribute) this.attrName.clone();
		wwb.attrOperation = (XMLAttribute) this.attrOperation.clone();
		wwb.attrLabel = (XMLAttribute) this.attrLabel.clone();
		wwb.fillStructure();
		return wwb;
	}

	public void afterImporting(List buttonList) {

		
		if (buttonList == null) {
			return;
		}
		for (int i = 0; i < buttonList.size(); i++) {
			ExtendedAttribute ea = (ExtendedAttribute) buttonList.get(i);
			String nm = ea.get("Name").toValue().toString();
			nm = nm.substring((CommonAttributeTable.ATTACHMENT + ".").length());
			String value = ea.get("Value").toValue().toString();
			if (nm.indexOf(".") == -1) {
				attrCode.setValue(nm);
				attrName.setValue(value);
			} else {
				String rightGroup = nm.substring(nm.indexOf(".") + 1);
				attrOperation.setValue(((CommonAttributeTableButtons) getCollection())
						.getButtonName(value));
				attrLabel.setValue(rightGroup);
			}
		}
	}

}
