/*
 * Created on 2004-3-4
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.commonattribut;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.plugin.PluginElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.plugin.impl.activity.Message;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.config.BPDPlugin;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 活动表单中Attachment插件
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author wenzhangliz 2007-3-4 15:41:49
 * @version 1.0
 */
public class CommonAttributeTable extends PluginElement {

	private static final long serialVersionUID = 1L;

	public static String ATTACHMENT = "COMMONATTRIBUTE";

	public static String ButtonNameDisplay = "NAME";

	public static String ButtonOperationDisplay = "SELECT";

	public static final String APPLICATION_NAME = "APPLICATION";

	private XMLElement CommonAttributeButtons;

	// 活动对象
	private Activity act;

	// 流程对象
	private WorkflowProcess wp;

	/**
	 * Construct a Attachment instance.
	 */
	public CommonAttributeTable(BPDPlugin plugin) {
		super(plugin);
		CommonAttributeButtons = new CommonAttributeTableButtons(this);
		String LabelName = (String) this
				.getProperty("CommonAttributeTable.LabelName");
		// setLabelName(Message
		// .getLanguageDependentString("Activity.CommonAttributeTable.display"));
		setLabelName(LabelName);
		fillStructure();
	}

	public String getCommonAttributeTableKey() {
		return (String) this.getProperty("CommonAttributeTableKey");
	}

	protected void fillStructure() {
		complexStructure.add(CommonAttributeButtons);
	}

	public Object clone() {
		CommonAttributeTable ww = (CommonAttributeTable) super.clone();
		ww.CommonAttributeButtons = (XMLElement) this.CommonAttributeButtons
				.clone();
		ww.fillStructure();
		return ww;
	}

	// 获取CommonAttributeTable的按钮显示名称和按钮代码
	public String[][] getButtons() {

		Object obj = wp.getProperty("CommonAttributeTableButtons");
		if (obj != null) {
			return (String[][]) obj;
		}
		String[][] buttons = null;

		String configValue = (String) this.getProperty("ConfigOption");
		if (configValue != null) {
			String[] configValues = Utils.tokenize(configValue, " ");
			buttons = new String[configValues.length][2];
			for (int i = 0; i < buttons.length; i++) {
				buttons[i][0] = configValues[i];
				buttons[i][1] = (String) this.getProperty(configValues[i]
						+ ".Name");

			}
		} else {
			String strButtonNames = (String) this.getProperty("ButtonNames");

			// String strButtonNames = Message
			// .getLanguageDependentString("Activity.CommonAttributeTable.Button.name");

			String[] array_bns = Utils.tokenize(strButtonNames, " ");

			String strButtonCodes = (String) this.getProperty("strButtonCodes");
			// String strButtonCodes = Message
			// .getLanguageDependentString("Activity.CommonAttributeTable.Button.code");

			String[] array_bcs = Utils.tokenize(strButtonCodes, " ");
			if (array_bns.length != array_bcs.length) {
				return buttons;
			}
			buttons = new String[array_bns.length][2];
			for (int i = 0; i < array_bns.length; i++) {
				String name = array_bns[i];
				String code = array_bcs[i];
				buttons[i][0] = code;
				buttons[i][1] = name;
			}
		}
		wp.setProperty("CommonAttributeTableButtons", buttons);
		return buttons;
	}

	// 获取CommonAttributeTable操作状态
	public String[][] getOperationState() {
		Object obj = wp.getProperty("CommonAttributeTableButtonState");
		if (obj != null) {
			return (String[][]) obj;
		}
		// String[][] states = new String[][] { { "不可用", "0" }, { "可用", "1" } };
		String[][] states = this.getElemValues("CommonAttributeTable");

		wp.setProperty("CommonAttributeTableButtonState", states);
		return states;
	}

	public void loadProperties() throws PluginException {

		this.setProperty("CommonAttributeTableKey", (String) this
				.getProperty("CommonAttributeTable.key"));
		ATTACHMENT = (String) this.getProperty("CommonAttributeTable.key");

		this.setLabelName((String) this
				.getProperty("CommonAttributeTable.LabelName"));
		Object obj = getProperty("Activity");
		if (obj == null) {
			throw new PluginException(Message
					.getLanguageDependentString("Plugin.Initialize.Error"));
		}
		act = (Activity) obj;
		Object wpObj = getProperty("WorkflowProcess");
		if (wpObj == null) {
			throw new PluginException(Message
					.getLanguageDependentString("Plugin.Initialize.Error"));
		}
		wp = (WorkflowProcess) wpObj;
	}

	// 得到属性值为CheckBox时选择范围
	private String[][] getElemValues(String val) {
		String elemName = (String) getProperty(val + ".SelectOption");
		String[] elemNames = Utils.tokenize(elemName, " ");
		String[][] values = new String[elemNames.length][2];
		for (int i = 0; i < values.length; i++) {
			String elem = elemNames[i];
			String[] elemValues = Utils.tokenize(elem, "|");
			values[i][0] = elemValues[1];
			values[i][1] = elemValues[0];
		}
		return values;
	}

	// 从活动扩展属性保存到CommonAttributeTable对象
	public void afterImporting() throws PluginException {
		ExtendedAttributes exAttrs = (ExtendedAttributes) act
				.get("ExtendedAttributes");
		String key = this.getCommonAttributeTableKey();
		Set easToRemove = new HashSet();
		Iterator it = exAttrs.toCollection().iterator();
		String nm = "";
		String val = "";
		List buttons = new ArrayList();
		while (it.hasNext()) {
			ExtendedAttribute ea = (ExtendedAttribute) it.next();
			nm = ea.get("Name").toValue().toString();
			val = ea.get("Value").toValue().toString();
			if (nm.startsWith(key)) {
				easToRemove.add(ea);
				if (!nm.equalsIgnoreCase(key)) {
					buttons.add(ea);
				}
			}
		}
		exAttrs.toCollection().removeAll(easToRemove);
		((CommonAttributeTableButtons) CommonAttributeButtons)
				.afterImporting(buttons);
	}
}
