/*
 * Created on 2004-2-18
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.activity.jdsform;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import com.ds.bpm.bpd.plugin.impl.process.Form;
import com.ds.bpm.bpd.xml.XMLCollection;


import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.enums.form.FormNameEnum;
import com.ds.enums.attribute.Attributetype;
import org.w3c.dom.Element;
import org.w3c.dom.Node;


public class MDForms extends XMLCollection {


    public MDForms(XMLComplexElement myOwner) {
        super(myOwner);
        setLabelName("选择表单");
        fillStructure();
    }

    @Override
    public XMLElement generateNewElement() {
        ActForm f = new ActForm(this);
        f.setRequired(true);
        return f;
    }

    protected void fillStructure() {

    }


    public XMLPanel getPanel() {
        controlledPanel = new XMLActivityFormPanel(this, "", false, false);
        controlPanel = new XMLActivityFormControlPanel(this, "", true, false);
        return new XMLGroupPanel(this, new XMLPanel[]{controlledPanel,
                controlPanel}, toLabel(), XMLPanel.BOX_LAYOUT, false, true);
    }


    public Object clone() {
        MDForms f = (MDForms) super.clone();
        return f;
    }

    public int[] getInvisibleTableFieldOrdinals() {
        return new int[]{0};
    }


    public void toXML(Node parent) {
        if (!isEmpty() || isRequired()) {
            if (parent != null) {

                String names = "";
                for (Iterator it = refCollectionElements.iterator(); it.hasNext(); ) {
                    ActForm xmlElement = (ActForm) it.next();
                    xmlElement.toXML(parent);
                    names = xmlElement.getID() + ";" + names;
                }

                Element elem = parent.getOwnerDocument().createElement(
                        "ExtendedAttribute");
                elem.setAttribute("Name", FormNameEnum.FORM.getType());
                elem.setAttribute("Type", Attributetype.PAGE.getType());
                elem.setAttribute("Value", names);
                parent.appendChild(elem);
            }
        }
    }

    public void afterImporting(List wpForms) {
        if (wpForms == null) {
            return;
        }
        for (int i = 0; i < wpForms.size(); i++) {
            ExtendedAttribute ea = (ExtendedAttribute) wpForms.get(i);
            String nm = ea.get("Name").toValue().toString();
            nm = nm.substring((FormNameEnum.FORM.getType() + ".").length());
            if (nm.indexOf(".") == -1) {
                ActForm formElem = (ActForm) generateNewElement();
                add(formElem);
                formElem.afterImporting(ea);
            }
        }
    }

}
