/*
 * Created on 2004-2-23
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.activity.jdsform;

import java.util.Iterator;
import java.util.List;

import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 流程启动附件集合类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-2-23 1:04:25
 * @version 1.0
 */
public class AttachmentDefs extends XMLCollection {

	/**
	 * 构造器
	 * 
	 * @param myOwner
	 */
	// 可配置操作状态
	private String[][] states;

	
	public AttachmentDefs(XMLComplexElement myOwner) {
		super(myOwner);
		states = new String[][] { { "不可用", "0" }, { "可用", "1" } };
		setLabelName("附件管理");
	}

	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		AttachmentDef f = new AttachmentDef(this);
		f.setRequired(true);
		return f;
	}

	/**
	 * Creates panel which allows user to manipulate with instances of classes
	 * that makes a collection that this class represents. The panel consists of
	 * two sections: XMLListPanel - shows collections' elements, and
	 * XMLListControlPanel - display buttons for manipulating with that
	 * elements.
	 * <p>
	 * NOTE: The order of creation is relevant, first, the controlled panel must
	 * be created, and then the control panel
	 * 
	 * @return DTDPanel to be shown
	 */
	public XMLPanel getPanel() {
		controlledPanel = new XMLAttachmentDefPanel(this, "", false, false);
		controlPanel = new XMLAttachmentDefControlPanel(this, "", true, false);
		return new XMLGroupPanel(this, new XMLPanel[] { controlledPanel,
				controlPanel }, toLabel(), XMLPanel.BOX_LAYOUT, false, true);
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		AttachmentDefs f = (AttachmentDefs) super.clone();
		return f;
	}

//	 表格中不显示的数据项
	public int[] getInvisibleTableFieldOrdinals() {
		return new int[] { 0 };
	}

	// 表格中可以编辑的数据项
	public int[] getEditableTableFieldOrdinals() {
		return new int[] { 2 };
	}

	// 表格中某列编辑框
	public DefaultCellEditor getEditableDefaultValue(int column) {
		DefaultCellEditor cellEditor = null;
		if (column == 2 && states != null && states.length > 0) {
			JComboBox jcb = new JComboBox();
			jcb.addItem(new XMLSelectOption("", ""));
			for (int i = 0; i < states.length; i++) {
				String[] item = states[i];
				XMLSelectOption option = new XMLSelectOption(item[0], item[1]);
				jcb.addItem(option);
			}
			cellEditor = new DefaultCellEditor(jcb);
		}
		return cellEditor;
	}

	public void toXML(Node parent) {
		if (!isEmpty() || isRequired()) {
			if (parent != null) {
			
				
				Element elem = parent.getOwnerDocument().createElement(
						"ExtendedAttribute");
				elem.setAttribute("Name", AttachmentPlugin.FORM_NAME);
				elem.setAttribute("Type", AttachmentPlugin.TYPE_NAME);
				Activity at=(Activity) ((AttachmentPlugin)this.getOwner()).getProperty("Activity");
				ExtendedAttributes exAttrs = (ExtendedAttributes) at
				.get("ExtendedAttributes");
				Iterator iit = exAttrs.toCollection().iterator();
			
				while (iit.hasNext()) {
					ExtendedAttribute ea = (ExtendedAttribute) iit.next();
					String nm =  ea.get("Name").toValue().toString();
			
					if (nm.startsWith(AttachmentPlugin.FORM_NAME)) {
						exAttrs.toCollection().remove(ea);
					}
				}
				
				
				String ids="";
				for (Iterator it = refCollectionElements.iterator(); it
						.hasNext();) {
					AttachmentDef def= (AttachmentDef) it.next();
					ids=ids+def.getID()+";";
					
					def.toXML(parent);
				}
				elem.setAttribute("Value", ids);
				parent.appendChild(elem);
			}
		}
	}

	public void afterImporting(List wpForms) {
		if (wpForms == null) {
			return;
		}
		for (int i = 0; i < wpForms.size(); i++) {
			ExtendedAttribute ea = (ExtendedAttribute) wpForms.get(i);
			String nm = ea.get("Name").toValue().toString();
			nm = nm.substring((AttachmentPlugin.FORM_NAME + ".").length());
			if (nm.indexOf(".") == -1) {
				AttachmentDef formElem = (AttachmentDef) generateNewElement();
				add(formElem);
				formElem.afterImporting(ea);
			}
		}
	}
}
