/*
 * Created on 2004-3-4
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.activity.jdsform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.WorkflowManager;
import com.ds.bpm.bpd.plugin.PluginElement;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.RightGroups;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;
import com.ds.bpm.bpd.xml.panels.XMLTablePanel;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: Attachment中可操作按钮集合
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-3-4 16:47:35
 * @version 1.0
 */
public class AttachmentButtons extends XMLCollection {

	private AttachmentButtons[] wwbsArray;

	// 流程权限组
	private List rightGroups;

	// 可配置操作状态
	private String[][] states;

	/**
	 * Construct a AttachmentButtons instance.
	 * 
	 * @param myOwner
	 */
	public AttachmentButtons(XMLComplexElement myOwner) {
		super(myOwner);
	}

	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		AttachmentButton wwb = new AttachmentButton(this);
		wwb.setRequired(true);
		return wwb;
	}

	public XMLElement generateNewElement(XMLCollection collection) {
		AttachmentButton wwb = new AttachmentButton(collection);
		wwb.setRequired(true);
		return wwb;
	}

	public XMLPanel getPanel() {
		if (rightGroups == null) {
			loadProperties();
		}
		// 得到Attachment的所有Button
		String[][] buttons = ((Attachment) getOwner()).getButtons();
		if (buttons == null || buttons.length < 1) {
			return null;
		}
		if (wwbsArray == null) {
			wwbsArray = new AttachmentButtons[rightGroups.size()];
		}
		List panels = new ArrayList();
		for (int index = 0; index < wwbsArray.length; index++) {
			AttachmentButtons wwbs = wwbsArray[index];
			if (wwbs == null || wwbs.toCollection().size() == 0) {
				wwbs = new AttachmentButtons(getOwner());
				wwbs.loadProperties();
				if (buttons != null || buttons.length > 0) {
					for (int i = 0; i < buttons.length; i++) {
						AttachmentButton wwb = (AttachmentButton) generateNewElement(wwbs);
						((XMLAttribute) wwb.get("Code"))
								.setValue(buttons[i][0]);
						((XMLAttribute) wwb.get("Name"))
								.setValue(buttons[i][1]);
						XMLAttribute attrLabel = ((XMLAttribute) wwb
								.get("Label"));
						String[] rightGroup = (String[]) rightGroups.get(index);
						attrLabel.setValue(rightGroup[1]);
						if (rightGroup[1].equals(RightGroups.PERFORMER_GROUP)
								&& states != null && states.length > 0) {
							((XMLAttribute) wwb.get("Operation"))
									.setValue(new XMLSelectOption(states[1][0],
											states[1][1]));
						}
						wwbs.add(wwb);
					}
				}
				wwbsArray[index] = wwbs;
			}
			String[] rightGroup = (String[]) rightGroups.get(index);
			String label = rightGroup[0];

			XMLTablePanel tablePanel = new XMLAttachmentPanel(wwbs, "", false,
					false, true, true);
			panels.add(new XMLGroupPanel(this, new XMLPanel[] { tablePanel },
					label, XMLPanel.BOX_LAYOUT, false, true));
		}
		XMLTabbedPanel tabbedPanel = new XMLTabbedPanel(this,
				(XMLPanel[]) panels.toArray(new XMLPanel[] {}));
		return tabbedPanel;
	}

	private void loadProperties() {
		// 得到工作流的权限组
		Activity act = (Activity) ((PluginElement) myOwner)
				.getProperty("Activity");
		WorkflowProcess process = act.getOwnerProcess();
		rightGroups = (List) WorkflowManager.getAllRightGroup(process);
		states = ((Attachment) myOwner).getOperationState();
	}

	// 表格中不显示的数据项
	public int[] getInvisibleTableFieldOrdinals() {
		return new int[] { 0, 1, 4 };
	}

	// 表格中可以编辑的数据项
	public int[] getEditableTableFieldOrdinals() {
		return new int[] { 4 };
	}

	// 表格中某列编辑框
	public DefaultCellEditor getEditableDefaultValue(int column) {
		DefaultCellEditor cellEditor = null;
		if (column == 4 && states != null && states.length > 0) {
			JComboBox jcb = new JComboBox();
			jcb.addItem(new XMLSelectOption("", ""));
			for (int i = 0; i < states.length; i++) {
				String[] item = states[i];
				XMLSelectOption option = new XMLSelectOption(item[0], item[1]);
				jcb.addItem(option);
			}
			cellEditor = new DefaultCellEditor(jcb);
		}
		return cellEditor;
	}

	// 保存Attachment信息
	public void toXML(Node parent) {
		if (parent != null) {
			Element elem = parent.getOwnerDocument().createElement(
					"ExtendedAttribute");
			elem.setAttribute("Name", Attachment.ATTACHMENT);
			elem.setAttribute("Type", Attachment.APPLICATION_NAME);
			elem.setAttribute("Value", "");
			parent.appendChild(elem);
			if (wwbsArray != null && wwbsArray.length > 0) {
				for (int i = 0; i < wwbsArray.length; i++) {
					AttachmentButtons wwbs = wwbsArray[i];
					for (Iterator it = wwbs.getTableElements().iterator(); it
							.hasNext();) {
						XMLElement e = (XMLElement) it.next();
						e.toXML(parent);
					}
				}
			}
		}
	}

	public String getButtonName(String value) {
		String name = value;
		for (int i = 0; i < states.length; i++) {
			String[] state = (String[]) states[i];
			if (state[1].equals(value)) {
				name = state[0];
				break;
			}
		}
		return name;
	}

	public String getButtonValue(String name) {
		String value = name;
		for (int i = 0; i < states.length; i++) {
			String[] state = (String[]) states[i];
			if (state[0].equals(name)) {
				value = state[1];
				break;
			}
		}
		return value;
	}

	public void afterImporting(List buttons) {
		if (buttons == null) {
			return;
		}

		// 取得Attachment的所有Button
		List buttonsList = new ArrayList();
		for (int i = 0; i < buttons.size(); i++) {
			ExtendedAttribute ea = (ExtendedAttribute) buttons.get(i);
			String nm = ea.get("Name").toValue().toString();
			if (nm.indexOf(Attachment.ATTACHMENT + ".") != -1) {
				nm = nm.substring((Attachment.ATTACHMENT + ".").length());
				if (nm.indexOf(".") == -1) {
					buttonsList.add(ea);
				}
			}
		}

		// 取得配置权限组
		if (rightGroups == null) {
			loadProperties();
		}
		int index = rightGroups.size();
		List labels = new ArrayList();
		for (int i = 0; i < rightGroups.size(); i++) {
			labels.add(((String[]) rightGroups.get(i))[1]);
		}
		int count = 0;
		Map buttonsMap = new HashMap();
		for (int i = 0; i < buttonsList.size(); i++) {
			count = 0;
			ExtendedAttribute ea = (ExtendedAttribute) buttonsList.get(i);
			String buttonName = ea.get("Name").toValue().toString();
			List list = new ArrayList();
			for (int k = 0; k < labels.size(); k++) {
				String label = (String) labels.get(k);
				boolean isExisted = false;
				for (int j = 0; j < buttons.size(); j++) {
					ExtendedAttribute tmp = (ExtendedAttribute) buttons.get(j);
					String nm = tmp.get("Name").toValue().toString();
					if (nm.equalsIgnoreCase(buttonName + "." + label)) {
						list.add(tmp);
						isExisted = true;
						count++;
						break;
					}
				}
				if (!isExisted) {
					ExtendedAttribute newEA = new ExtendedAttribute();
					newEA.set("Name", buttonName + "." + label);
					list.add(newEA);
				}
			}
			if (count > index) {
				index = count;
			}
			buttonsMap.put(buttonName, list);
		}

		wwbsArray = new AttachmentButtons[index];
		for (int i = 0; i < wwbsArray.length; i++) {
			wwbsArray[i] = new AttachmentButtons(getOwner());
			wwbsArray[i].loadProperties();
			for (int j = 0; j < buttonsList.size(); j++) {
				List wwbList = new ArrayList();
				ExtendedAttribute ea = (ExtendedAttribute) buttonsList.get(j);
				String fieldName = ea.get("Name").toValue().toString();
				wwbList.add(ea);
				List list = (List) buttonsMap.get(fieldName);
				wwbList.add(list.get(i));
				AttachmentButton wwb = (AttachmentButton) generateNewElement(wwbsArray[i]);
				wwbsArray[i].add(wwb);
				wwb.afterImporting(wwbList);
			}
		}
	}

	// 实现clone方法
	public Object clone() {
		if (rightGroups == null) {
			loadProperties();
		}
		AttachmentButtons wws = (AttachmentButtons) super.clone();
		if (wwbsArray != null && wwbsArray.length > 0) {
			wws.wwbsArray = new AttachmentButtons[rightGroups.size()];
			for (int i = 0; i < wwbsArray.length; i++) {
				wws.wwbsArray[i] = new AttachmentButtons(getOwner());
				wws.wwbsArray[i].loadProperties();
				for (Iterator it = wwbsArray[i].toCollection().iterator(); it
						.hasNext();) {
					AttachmentButton wwb = (AttachmentButton) it.next();
					wws.wwbsArray[i].add((AttachmentButton) wwb.clone());
				}
			}
		}
		return wws;
	}
}
