/*
 * Created on 2004-2-23
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.activity.jdsform;


import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.plugin.impl.process.Message;
import com.ds.bpm.bpd.xml.*;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.panels.XMLComboPanel;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.enums.form.FormNameEnum;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ActForm extends XMLCollectionElement {


    private XMLElement attrName = new XMLAttribute("Value");


    private XMLAttribute attrDesc = new XMLAttribute("Description");

    private XMLElement form;

    String[][] chooseForms;

    public ActForm(XMLCollection myCollection) {
        super(myCollection);
        setLabelName("流转表单");
        attrId
                .setLabelName(Message
                        .getLanguageDependentString("Activity.JDSForm.MainForm.ID.display"));
        attrName
                .setLabelName("名称");
        attrDesc
                .setLabelName("类名");

        fillStructure();
    }

    protected void fillStructure() {
        super.fillStructure();
        complexStructure.add(attrName);
        attributes.add(attrName);
        complexStructure.add(attrDesc);
        attributes.add(attrDesc);

    }

    // 表格中可以编辑的数据项
    public int[] getEditableTableFieldOrdinals() {
        return new int[]{2};
    }

    public XMLPanel getPanel() {
        chooseForms = ((JDSForm) getCollection().getOwner()).getForms();
        if (chooseForms != null) {
            form = new XMLComplexChoice("Form", null, 0) {
                public XMLPanel getPanel() {
                    choices = chooseForms;
                    if (getChoosen() == null && choices != null
                            && choices.length > 0) {
                        XMLSelectOption obj;
                        if (!attrName.toValue().toString().equals("")
                                && !attrId.toValue().toString().equals("")) {
                            obj = new XMLSelectOption(attrName.toValue()
                                    .toString(), attrId.toValue().toString());
                        } else {
                            obj = new XMLSelectOption(
                                    ((String[]) choices[0])[0],
                                    ((String[]) choices[0])[1]);
                        }
                        super.setValue(obj);
                    }
                    return new XMLComboPanel(this, chooseForms);
                }

                public void setValue(Object v) {
                    if (choices != null && getChoosen() != null) {
                        super.setValue(v);
                        XMLSelectOption choose = (XMLSelectOption) getChoosen();
                        attrId.setValue(choose.getText());
                        attrName.setValue(choose.getName());
                        attrDesc.setValue(getValueFromArray(chooseForms, choose
                                .getText(), 2));
                    }
                }
            };
            form
                    .setLabelName("选择表单");
            return new XMLGroupPanel(this, new XMLElement[]{form});
        } else {
            return null;
        }
    }


    public Object clone() {
        ActForm f = (ActForm) super.clone();
        f.attrName = (XMLElement) this.attrName.clone();
        f.attrDesc = (XMLAttribute) this.attrDesc.clone();

        f.fillStructure();
        return f;
    }

    private String getValueFromArray(String[][] array, String id, int index) {
        String ret = "";
        for (int i = 0; i < array.length; i++) {
            String[] cell = array[i];
            if (index < 0 || index >= cell.length) {
                return "";
            }
            if (cell[1].equals(id)) {
                ret = cell[index];
                break;
            }
        }
        return ret;
    }

    public boolean hasForms() {
        return (chooseForms != null && chooseForms.length > 0);
    }

    public void toXML(Node parent) {
        Element elem = parent.getOwnerDocument().createElement(
                "ExtendedAttribute");
        elem.setAttribute("Name", JDSForm.FORM_NAME + "."
                + attrId.toValue().toString());
        elem.setAttribute("Type", JDSForm.TYPE_NAME);
        elem.setAttribute("Value", attrName.toValue().toString() + ";"
                + attrDesc.toValue().toString());
        parent.appendChild(elem);
    }

    public void afterImporting(Object obj) {
        if (obj instanceof ExtendedAttribute) {
            ExtendedAttribute ea = (ExtendedAttribute) obj;
            String nm = ea.get("Name").toValue().toString();
            nm = nm.substring((FormNameEnum.FORM.getType() + ".").length());
            if (nm.indexOf(".") == -1) {
                attrId.setValue(nm);
                String value = ea.get("Value").toValue().toString();
                String[] vs = Utils.tokenize(value, ";");
                if (vs != null && vs.length >= 2) {
                    attrName.setValue(vs[0]);
                    attrDesc.setValue(vs[1]);
                }
            }
        }
    }
}
