package com.ds.bpm.bpd.misc.treenode;

import com.ds.bpm.bpd.misc.PackageTreePanel;
import com.ds.bpm.client.ProcessDef;
import com.ds.bpm.client.ProcessDefVersion;
import com.ds.bpm.engine.BPMException;

import javax.swing.tree.DefaultMutableTreeNode;
import java.util.ArrayList;
import java.util.List;

/**
 * 远端流程节点
 * <p>
 * 内部类
 */
public class RemoteProcessDefNode extends DefaultMutableTreeNode {

    private final PackageTreePanel treePanel;
    // 是否张开的标志
    private boolean explore = false;

    /**
     * 构造方法
     *
     * @param processDef 远端流程对象
     */
    public RemoteProcessDefNode(ProcessDef processDef, PackageTreePanel treePanel) {
        setUserObject(processDef);
        this.treePanel = treePanel;
        explore();
    }

    /**
     * 获得远端流程对象
     *
     * @return
     */
    public ProcessDef getProcessDef() {
        return (ProcessDef) getUserObject();
    }

    /**
     * 是否准许有子节点
     */
    public boolean getAllowsChildren() {
        return true;
    }

    /**
     * 是否是叶节点
     */
    public boolean isLeaf() {
        return false;
    }

    /**
     * 是否已经展开
     *
     * @return explore
     */
    public boolean isExplore() {
        return explore;
    }

    /**
     * 获得显示字符串
     */
    public String toString() {
        ProcessDef processDef = getProcessDef();
        return processDef.getName();
    }

    /**
     * 展开流程节点
     */
    public void explore() {
        if (!isExplore()) {
            ProcessDef processDef = getProcessDef();
            List<ProcessDefVersion> processDefVersionList = new ArrayList<ProcessDefVersion>();
            try {
                processDefVersionList = processDef.getAllProcessDefVersions();
            } catch (BPMException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            for (ProcessDefVersion processDefVersion : processDefVersionList) {

                RemoteProcessDefVersionNode remoteProcessDefVersionNode = new RemoteProcessDefVersionNode(processDefVersion, treePanel);
                add(remoteProcessDefVersionNode);
                // 建立远程流程版本节点与远程流程版本ID的对应关系
                treePanel.getRemoteTreeNodeMap().put(remoteProcessDefVersionNode, processDefVersion.getProcessDefVersionId());
            }

            explore = true;
        }
    }

}