package com.ds.bpm.bpd.misc.treenode;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.misc.PackageTreePanel;
import com.ds.bpm.client.ProcessDef;
import com.ds.config.CApplication;
import com.ds.config.BPDProjectConfig;

import javax.swing.tree.DefaultMutableTreeNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * 远端应用节点
 * <p>
 * 内部类
 */
public class RemoteAppDefNode extends DefaultMutableTreeNode {

    private final PackageTreePanel treePanel;
    public Map nodeMap = new HashMap();

    // 是否张开的标志
    private boolean explore = false;

    /**
     * 构造方法
     */
    public RemoteAppDefNode(CApplication app, PackageTreePanel treePanel) {
        this.treePanel = treePanel;
        setUserObject(app);
        explore();
    }

    /**
     * 获得远端应用对象
     *
     * @return
     */
    public CApplication getAPP() {
        return (CApplication) getUserObject();
    }

    /**
     * 是否准许有子节点
     */
    public boolean getAllowsChildren() {
        return true;
    }

    /**
     * 是否是叶节点
     */
    public boolean isLeaf() {
        return false;
    }

    /**
     * 是否已经展开
     *
     * @return explore
     */
    public boolean isExplore() {
        return explore;
    }

    /**
     * 获得显示字符串
     */
    public String toString() {
        CApplication app = getAPP();
        return app.getName();
    }

    /**
     * 展开流程节点
     */
    public void explore() {
        if (!isExplore()) {
            CApplication app = getAPP();
            Map<String, BPDProjectConfig> classificationsConfigMap = app.getBPDProjectConfigMap();

            Map<String, ProcessDef> processDefMap = BPD.getInstance().getRemoteProcessMap();
            Iterator<String> it = processDefMap.keySet().iterator();
            for (; it.hasNext(); ) {
                ProcessDef processDef = processDefMap.get(it.next());
                String classificationsCode = processDef.getClassification();
                BPDProjectConfig classification = classificationsConfigMap.get(classificationsCode);

                if (classification != null && !this.nodeMap.containsKey(classificationsCode) && processDef.getSystemCode().equals(this.getAPP().getSysId())) {

                    RemoteClassificationDefNode remoteClassificationDefNode = new RemoteClassificationDefNode(classification, treePanel);
                    add(remoteClassificationDefNode);
                    nodeMap.put(classificationsCode, remoteClassificationDefNode);
                }

            }

            explore = true;
        }
    }


}
