package com.ds.bpm.bpd.misc.task;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.common.swing.progress.Task;
import com.ds.common.swing.util.SwingWorker;

/**
 * 打开远端流程时的进程显示类
 *
 * @author Administrator
 * <p>
 * To change the template for this generated type comment go to Window - Preferences - Java - Code
 * Generation - Code and Comments
 */
public class OpenProcessTask extends Task {

    private String remoteVersionId;

    public OpenProcessTask(String remoteVersionId) {
        this.remoteVersionId = remoteVersionId;
        setLengthOfTask(10);
    }


    /*
     * 获得流程列表
     *
     * @see com.risenet.common.swing.progress.Task#go()
     */
    public void go() {
        final SwingWorker worker = new SwingWorker() {
            public Object construct() {
                try {
                    setMessage(ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Message.GetProcessInfo.Name.display"));

                    String xpdlString = "";
                    // 获得WebService服务对象

                    xpdlString = BPD.getInstance().getPackProcessDefList(remoteVersionId);

                    setMessage(ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Message.OpenProcess.Name.display"));

                    // 打开选择的流程
                    BPD.getInstance().openWFFromString(xpdlString);
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    stop();
                }
                return new Object();
            }
        };
        worker.start();
    }

    /*
     * @see com.ds.common.swing.progress.Task#cancel()
     */
    public void cancel() {
    }

    /*
     * @see com.ds.common.swing.progress.Task#complete()
     */
    public void complete() {
    }
}