package com.ds.bpm.bpd.misc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.BarFactory;
import com.ds.bpm.bpd.ProcessEditor;
import com.ds.bpm.bpd.TextPreview;
import com.ds.bpm.bpd.TextTreeModel;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.WorkflowManager;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.activity.Activities;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ActivitySet;
import com.ds.bpm.bpd.xml.elements.Package;
import com.ds.bpm.bpd.xml.elements.Transition;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.WorkflowProcesses;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Class represents left side of TextView
 * @author Zoran Milakovic zoran@prozone.co.yu
 * @version 1.0
 */
public class TextTreePanel extends XMLPanel {

	private TextTreeModel treeModel;

	private final JTree jtree;

	private JScrollPane allItemsPane;

	public static Map panelMap = new HashMap();

	public static TextTreePanel getInstance(
			Package myOwner,
			TextPreview txPreview, String title) {
		TextTreePanel ttp = null;
		if (myOwner == null) {
			ttp = new TextTreePanel();
			panelMap.put(myOwner, ttp);
			return ttp;
		}
		if (panelMap.containsKey(myOwner)) {
			ttp = (TextTreePanel) panelMap.get(myOwner);
		} else {
			ttp = new TextTreePanel(myOwner, txPreview, title);
			panelMap.put(myOwner, ttp);
		}
		return ttp;
	}

	public TextTreePanel() {
		super();
		jtree = new JTree(treeModel) {
			public boolean isCellEditable(int row, int col) {
				return false;
			}
		};
	}

	public TextTreePanel(Package myOwner,
			TextPreview txPreview, String title) {

		super(myOwner, 2, title, XMLPanel.BOX_LAYOUT, true, true);
		treeModel = new TextTreeModel(myOwner.get("WorkflowProcesses"));

		jtree = new JTree(treeModel) {
			public boolean isCellEditable(int row, int col) {
				return false;
			}
		};

		// setting some tree properties
		jtree.getSelectionModel().setSelectionMode(
				TreeSelectionModel.SINGLE_TREE_SELECTION);
		jtree.setRootVisible(true);
		DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
		renderer.setBackground(Utils.getColor(BPDConfig.getInstance()
				.getBackgroundColor()));
		renderer.setBackgroundNonSelectionColor(Utils.getColor(BPDConfig
				.getInstance().getBackgroundColor()));
		jtree.setCellRenderer(renderer);
		jtree.setBackground(Utils.getColor(BPDConfig.getInstance()
				.getBackgroundColor()));

		jtree.addTreeSelectionListener(new TreeSelectionListener() {
			public void valueChanged(TreeSelectionEvent e) {
				DefaultMutableTreeNode node = (DefaultMutableTreeNode) jtree
						.getLastSelectedPathComponent();
				if (node == null)
					return;
				XMLElement element = (XMLElement) node
						.getUserObject();

				if (element == null) {

				}
			}
		});

		/** MouseListener for jtree */
		MouseListener mouseListener = new MouseAdapter() {
			public void mouseClicked(MouseEvent me) {

				DefaultMutableTreeNode node = (DefaultMutableTreeNode) jtree
						.getLastSelectedPathComponent();
				if (node == null)
					return;

				XMLElement element = (XMLElement) node
						.getUserObject();

				TextPreview.getInstance(BPD.getInstance().getPackageEditor())
						.refreshView(element);

				if (SwingUtilities.isRightMouseButton(me)) {
					int x = me.getX();
					int y = me.getY();
					// Create the popup menubar.
					JPopupMenu popup = new JPopupMenu();

					JMenuItem menuItem1 = BarFactory
							.createMenuItem(Utils
									.getUnqualifiedClassName(com.ds.bpm.bpd.actions.EditProperties.class));

					menuItem1
							.addActionListener(new ShowPropertyDialogActionListener(
									jtree, x, y, null));

					// expand all item
					JMenuItem menuItem2 = BarFactory
							.createMenuItem("ExpandAll");
					menuItem2.addActionListener(new ExpandAllActionListener(
							jtree, x, y));
					// collapse all item
					JMenuItem menuItem3 = BarFactory
							.createMenuItem("CollapseAll");
					menuItem3.addActionListener(new CollapseAllActionListener(
							jtree, x, y));
					JMenuItem menuItem4 = BarFactory
							.createMenuItem("RefreshView");
					menuItem4.addActionListener(new RefreshViewActionListener(
							jtree, x, y));

					popup.add(menuItem1);
					popup.add(menuItem2);
					popup.add(menuItem3);
					popup.add(menuItem4);
					popup.show(jtree, me.getX(), me.getY());
				} else {
					if (element instanceof Transition) {
						Transition transition = (Transition) element;
						if (BPD.getInstance().getActivedProcessEditor()
								.getGraph().getPropertyObject().equals(
										transition.getOwnerProcess())) {
							Set wc = new HashSet();
							wc.add(element);
							BPD.getInstance().setSelectionCells(wc, false);
						}
					}

					if (element instanceof Activity
							&& !(element instanceof Activities)) {
						Activity activity = (Activity) element;
						WorkflowProcess wp = activity.getOwnerProcess();
						Activity ret = wp.getActivities().getActivity(
								activity.getID());
						ActivitySet as = null;
						if (ret == null) {
							Iterator ass = wp.getActivitySets().toCollection()
									.iterator();
							while (ass.hasNext()) {
								as = (ActivitySet) ass.next();
								ret = ((Activities) as.get("Activities"))
										.getActivity(activity.getID());
								if (ret != null) {

									break;
								}
							}
						}
						;
						if (as != null) {

							Activity ba = wp.getOutflowActivity(as.getID());
							if (ba != null) {
								WorkflowManager wm = BPD.getInstance()
										.getActivedProcessEditor().getGraph()
										.getWorkflowManager();
								com.ds.bpm.bpd.graph.Outflow bag = (com.ds.bpm.bpd.graph.Outflow) wm
										.getActivity(ba.getID());
								if (bag != null) {
									//BPD.getInstance().getPackageEditor().getu
									//bag.showSubflow(pkg);
								}
							}
						}
						
//						
//						if (as != null) {
//
//							Activity ba = wp.getSubProcessList(as.getID());
//							if (ba != null) {
//								WorkflowManager wm = BPD.getInstance()
//										.getActivedProcessEditor().getGraph()
//										.getWorkflowManager();
//								com.ds.bpm.bpd.graph.Outflow bag = (com.ds.bpm.bpd.graph.Outflow) wm
//										.getActivity(ba.getID());
//								if (bag != null) {
//									//BPD.getInstance().getPackageEditor().getu
//									//bag.showSubflow(pkg);
//								}
//							}
//						}
//						
						if (BPD.getInstance().getActivedProcessEditor()
								.getGraph().getPropertyObject().equals(
										activity.getOwnerProcess())) {
							Set wc = new HashSet();
							wc.add(element);
							BPD.getInstance().setSelectionCells(wc, false);
						}
					} else if (element instanceof WorkflowProcess) {
						JTabbedPane ctp = BPD.getInstance().getPackageEditor()
								.getContentTabbedPane();
						Component[] processEditorArray = (Component[]) ctp
								.getComponents();
						for (int i = 0; i < processEditorArray.length; i++) {
							ProcessEditor processEditor = ((ProcessEditor) processEditorArray[i]);
							if (processEditor.getGraph().getPropertyObject()
									.equals(element)) {
								ctp.setSelectedComponent(processEditor);
								return;
							}
							;
						}
					}
				}
				if (me.getClickCount() > 1) {
					if (!(element instanceof WorkflowProcess)
							&& !(element instanceof Activities)
							&& !(element instanceof WorkflowProcesses)) {
						XMLElementDialog d = new XMLElementDialog((JFrame) BPD
								.getInstance().getPackageEditor().getWindow(),

						((XMLElement) node.getUserObject()).toString());

						d.editXMLElement(((XMLElement) node.getUserObject())
								.getPanel(), true, false);
					} else if (element instanceof WorkflowProcess) {
						WorkflowProcess scp = (WorkflowProcess) element;

						if (BPD.getInstance().getRemoteProcessMap()
								.containsKey(scp.getVersionID())) {
							BPD.getInstance().openRomveWorkflow(
									scp.getVersionID(), true);
						}
						if (BPD.getInstance().getLocalEditingProcessMap()
								.containsKey(scp.getVersionID())) {
							BPD.getInstance().openWorkflow(scp.getVersionID(),
									true);
						}
					}

				}
			}

		};

		jtree.addMouseListener(mouseListener);

		// jtree.addTreeExpansionListener( new BPDTreeExpansionListener(
		// this.textPreview ));

		this.allItemsPane = new JScrollPane();
		allItemsPane.setViewportView(jtree);
		allItemsPane.setBackground(Color.lightGray);
		allItemsPane.setPreferredSize(new Dimension(300, 300));
		add(allItemsPane);
	}

	public JScrollPane getJScrollPane() {
		return allItemsPane;
	}

	public TextTreeModel getTreeModel() {
		return treeModel;
	}

	public void refreshView(XMLElement element) {
		// BPD.getInstance().getPackageEditor().getXMLPackage();
		treeModel = new TextTreeModel(element);
		jtree.setModel(treeModel);
	}

	public JTree getTree() {
		return jtree;
	}

	/**
	 * Class that implements listener used for propertie dialog
	 */
	class ShowPropertyDialogActionListener implements ActionListener {

		JTree jtree;

		int x;

		int y;

		TextPreview textPreview;

		public ShowPropertyDialogActionListener(JTree jtree, int x, int y,
				TextPreview textPreview) {
			this.jtree = jtree;
			this.x = x;
			this.y = y;
			// this.textPreview = textPreview;
		}

		public void actionPerformed(ActionEvent e) {
			showPropertyDialog(jtree, x, y);
			// this.textPreview.refreshView();
		}

		private void showPropertyDialog(JTree jtree, int x, int y) {
			TreePath treePath = jtree.getPathForLocation(x, y);
			Object[] pathArray = treePath.getPath();
			DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode) pathArray[pathArray.length - 1];

			XMLElementDialog d = new XMLElementDialog((JFrame) BPD
					.getInstance().getPackageEditor().getWindow(),
			// ResourceManager.getLanguageDependentString(
					// "DialogProperties" ) + " - " +
					//( ( XMLElement ) selectedNode.getUserObject() ).toName()
					((XMLElement) selectedNode.getUserObject()).toString());

			d.editXMLElement(((XMLElement) selectedNode.getUserObject())
					.getPanel(), true, false);
		}

	}

	/**
	 * Class that implements listener used for expand all
	 */
	class ExpandAllActionListener implements ActionListener {
		JTree jtree;

		int x;

		int y;

		public ExpandAllActionListener(JTree jtree, int x, int y) {
			this.jtree = jtree;
			this.x = x;
			this.y = y;
		}

		public void actionPerformed(ActionEvent e) {
			XMLUtil.expandAll(this.jtree, jtree.getPathForLocation(x, y), true);
		}
	}

	/**
	 * Class that implements listener used for collapse all
	 */
	class CollapseAllActionListener implements ActionListener {
		JTree jtree;

		int x;

		int y;

		public CollapseAllActionListener(JTree jtree, int x, int y) {
			this.jtree = jtree;
			this.x = x;
			this.y = y;
		}

		public void actionPerformed(ActionEvent e) {
			XMLUtil
					.expandAll(this.jtree, jtree.getPathForLocation(x, y),
							false);
		}
	}

	/**
	 * Class that implements listener used for refreshView
	 */
	class RefreshViewActionListener implements ActionListener {
		JTree jtree;

		int x;

		int y;

		public RefreshViewActionListener(JTree jtree, int x, int y) {
			this.jtree = jtree;
			this.x = x;
			this.y = y;
		}

		public void actionPerformed(ActionEvent e) {
			Package xmlpackage = null;
			if (BPD.getInstance().getActivedProcessEditor() != null) {
				xmlpackage = BPD.getInstance().getPackageEditor()
						.getXMLPackage();
				if (xmlpackage == null) {
					xmlpackage = BPD.getInstance().getPackageEditor()
							.getRealXMLPackage();
				}
			}
			TextTreePanel.this.refreshView(xmlpackage.get("WorkflowProcesses"));
		}
	}

	/**
	 * Class that implements listener used for expand and collapse
	 */
	class BPDTreeExpansionListener implements TreeExpansionListener {

		TextPreview textPreview;

		public BPDTreeExpansionListener(TextPreview textPreview) {
			this.textPreview = textPreview;
		}

		public void treeExpanded(TreeExpansionEvent e) {
			TreePath expandedPath = e.getPath();
			((XMLElement) ((DefaultMutableTreeNode) expandedPath
					.getLastPathComponent()).getUserObject())
					.setCollapsed(false);
			//         display();
		}

		public void treeCollapsed(TreeExpansionEvent e) {
			TreePath collapsedPath = e.getPath();
			((XMLElement) ((DefaultMutableTreeNode) collapsedPath
					.getLastPathComponent()).getUserObject())
					.setCollapsed(true);
			//         display();
		}

		//      private void display() {
		//         DefaultMutableTreeNode node = ( DefaultMutableTreeNode )
		//             jtree.getLastSelectedPathComponent();
		//         if ( node != null ) {
		//            com.ds.bpm.bpd.xml.XMLElement element =
		//                ( com.ds.bpm.bpd.xml.XMLElement )
		//                node.getUserObject();
		//            textPreview.display( element );
		//         }
		//      }

	}

}
