package com.ds.bpm.bpd.misc;


import com.ds.common.JDSException;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;
import com.ds.esd.plugins.api.enums.APIType;
import com.ds.esd.plugins.api.node.APIPaths;

import javax.swing.tree.TreeNode;
import java.util.*;

public class APITree {

    private  Project project;
    private APITreeNode root;
    public APITree(Project project) {
        this.project=project;
        Map<String, ComponentTreeNode> map = new HashMap<String, ComponentTreeNode>();
        root = new APITreeNode(project);

      String pattern=null;

        List<APIPaths> childernList = new ArrayList<APIPaths>();
        try {
            childernList =     ESDFacrory.getESDClient().getAPITopPaths(pattern, APIType.local);
        } catch (JDSException e) {
            e.printStackTrace();
        }
        for (APIPaths capis : childernList) {

            if (capis != null && capis.getChildren() != null && capis.getChildren().size() > 0) {
                APITreeNode node = new APITreeNode(capis);
                node.setLeaf(false);
                addComNode(node, capis.getChildren());
                insertNodeInto(node, root);

            }
        }

    }

    public APITree(APIPaths apiPaths) {

    }

    void addComNode(APITreeNode parentNode, List<APIPaths> capis) {
        for (APIPaths capi : capis) {
            if (capi != null) {
                if (capi.getChildren() != null && capi.getChildren().size() > 0) {
                    APITreeNode childNode = new APITreeNode(capi);
                    insertNodeInto(childNode, parentNode);
                    childNode.setLeaf(false);
                    addComNode(childNode, capi.getChildren());
                }
            }
        }
    }

    /**
     * @param parent
     * @param index
     * @return
     */
    public TreeNode getChild(TreeNode parent, int index) {
        return ((TreeNode) parent).getChildAt(index);
    }

    public Enumeration getChildren(TreeNode parent) {
        return parent.children();
    }

    public int getChildCount(TreeNode parent) {
        return parent.getChildCount();
    }

    public boolean isLeaf(TreeNode node) {
        return node.isLeaf();
    }

    public void insertNodeInto(APITreeNode newChild, ComponentTreeNode parent, int index) {
        if (newChild == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("parent is null");
        }

        parent.insert(newChild, index);
    }

    public void insertNodeInto(APITreeNode newChild, APITreeNode parent) {
        if (newChild == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("parent is null");
        }

        parent.insert(newChild);
    }

    public void removeNodeFromParent(APITreeNode node) {
        APITreeNode parent = (APITreeNode) node.getParent();
        if (parent == null)
            throw new IllegalArgumentException("node does not have a parent.");

        parent.remove(node);
    }

    public APITreeNode getRoot() {
        return root;
    }

    /**
     * @param root The root to set.
     */
    public void setRoot(APITreeNode root) {
        this.root = root;
    }

}
