/* SubflowRenderer.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：子流程活动图形描绘类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.Utils;

/**
 * Class used to display subflow object.
 */
public class SubflowRenderer extends ActivityRenderer {

	private BasicStroke innerBorderStroke = new BasicStroke(1);
	private String resurceImage="Pintsubflowactivity";

	/**
	 * Paints subflow. Overrides super class paint to add specific painting.
	 */
	public void paint(Graphics g) {
	
		super.paint(g);
		
		// drawing subflow border
		g.setColor(Color.BLACK);
		((Graphics2D) g).setStroke(innerBorderStroke);
		//g.drawRect(xOff, yOff, innerW - 1, innerH - 1);
		//g.drawLine(xOff + innerW +10, yOff, xOff + innerW - 1+10, innerH - 1);
		g.drawLine(xOff + innerW - 1+10, 0, xOff + innerW - 1+10, actH - 1);
		
		
		
	}

	protected Color getFillColor() {
		return Utils
				.getColor(BPDConfig.getInstance().getSubFlowActivityColor());
	}
	protected String getResurceImage(){
		return this.resurceImage;
	}

}
