/* ProcessRenderer.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：工作流描绘类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;

import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.Utils;

import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexRenderer;

/**
 * Class used to display process object.
 */
public class ProcessRenderer extends VertexRenderer {

	private BasicStroke borderStroke = new BasicStroke(2);

	/**
	 * Paints Process. Overrides super class paint to add specific painting.
	 */
	public void paint(Graphics g) {
		Color fillCol = Utils.getColor(BPDConfig.getInstance()
				.getProcessColor());
		int rrW = 50, rrH = 40;
		int b = borderWidth;
		Graphics2D g2 = (Graphics2D) g;
		Dimension d = getSize();
		boolean tmp = selected;

		if (super.isOpaque()) {
			g.setColor(fillCol);
			g.fillRoundRect(b - 1, b - 1, d.width - b, d.height - b, rrW, rrH);
		}
		try {
			setBorder(null);
			setOpaque(false);
			selected = false;
			super.paint(g);
		} finally {
			selected = tmp;
		}
		if (bordercolor != null) {
			g.setColor(bordercolor);
			g2.setStroke(borderStroke);
			g.drawRoundRect(b - 1, b - 1, d.width - b, d.height - b, rrW, rrH);
		}
		if (selected) {
			g2.setStroke(GraphConstants.SELECTION_STROKE);
			g.setColor(graph.getHighlightColor());
			g.drawRoundRect(b - 1, b - 1, d.width - b, d.height - b, rrW, rrH);
		}
	}

}
