/* Process.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：工作流图形构造类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.graph;

import java.awt.Window;

import javax.swing.JDialog;
import javax.swing.JFrame;

import com.ds.bpm.bpd.AbstractGraph;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ProcessEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;

/**
 * Used to define process object in graph and to modify it's properties.
 */
public class Process extends Activity {

	protected transient PackageEditor packageEditor;

	/**
	 * Reference to the process editor that will be created the first time the
	 * showProcess method is called.
	 */
	protected transient ProcessEditor pEditor = null;

	/**
	 * Creates process.
	 */
	public Process(PackageEditor pkgEd) {
		this(null, pkgEd);
		packageEditor = pkgEd;
	}

	/**
	 * Creates Process with given userObject.
	 */
	public Process(Object userObject, PackageEditor pkgEd) {
		super(userObject);
		packageEditor = pkgEd;
	}

	public ProcessEditor getImplementationEditor() {
		return pEditor;
	}

	public PackageEditor getPackageEditor() {
		return packageEditor;
	}

	public XMLElement getProcessProperties() {
		return pEditor.getGraph().getPropertyObject();
	}

	/**
	 * Shows a process editor with it's toolbar.
	 */
	public void showProcess() {
		WorkflowProcess wp = (WorkflowProcess) userObject;
		if (pEditor == null) {
			pEditor = new ProcessEditor(wp, packageEditor);
		}
		packageEditor
				.addProcessToTabbedPane(pEditor.getProcessTitle(), pEditor);
	}

	public void createWorkflowGraph(Window parentW) {
		pEditor = new ProcessEditor((WorkflowProcess) userObject, packageEditor);
		pEditor.getGraph().createWorkflowGraph(parentW);
	}

	/**
	 * Shows a dialog for editing activity properties. This is a place where
	 * undoing of property changes is realized.
	 */
	public void showPropertyDialog(Window parentWindow, AbstractGraph graph) {
		XMLElementDialog d;
		if (parentWindow instanceof JFrame) {
			d = new XMLElementDialog((JFrame) parentWindow, ResourceManager
					.getLanguageDependentString("DialogProcessProperties")
					+ " - " + userObject.toString());
		} else {
			d = new XMLElementDialog((JDialog) parentWindow, ResourceManager
					.getLanguageDependentString("DialogProcessProperties")
					+ " - " + userObject.toString());
		}
		d.editXMLElement(getPropertyObject().getPanel(), true, false);
	}

	/**
	 * Gets a tooltip text for activity.
	 */
	public String getTooltip() {
		try {
			return ((WorkflowProcess) userObject).getTooltip();
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * Gets a tooltip text for activity.
	 */
	public ProcessEditor getProcessEditor() {
		try {
			return pEditor;
		} catch (Exception e) {
			return null;
		}
	}

}
