/* Linkable.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：连接接口类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.graph;

/**
 * Defines the requirements for an object that represents a cell that should be
 * linked with other cells.
 */

public interface Linkable {
	/**
	 * Returns <code>true</code> if cell that implements it is a valid source
	 * for link.
	 */
	boolean acceptsSource();

	/**
	 * Returns <code>true</code> if cell that implements it is a valid target
	 * for link.
	 */
	boolean acceptsTarget();

}

/* End of Linkable.java */
