/* End.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：结束活动图形实现类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.graph;

import java.awt.Window;

import com.ds.bpm.bpd.AbstractGraph;
import com.ds.bpm.bpd.BPDConstants;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.EndActivity;

/**
 * Used to define End object.
 */
public class End extends Activity {

	EndActivity userObject;
	/**
	 * Creates end.
	 */
	public End() {
		this(null);
	}

	/**
	 * Creates End with given userObject.
	 */
	public End(EndActivity userObject) {
		super(userObject);
		this.userObject=userObject;
		activityVisualType = BPDConstants.TYPE_OF_ELEMENT_ENDING;
	}

	public void showPropertyDialog(Window parentWindow, AbstractGraph graph) {
	}

	/**
	 * Returns <code>true</code> if End is a valid target for transition. This
	 * depends if there is any transition already connected to it.
	 */
	public boolean acceptsTarget() {
		if (getIncomingTransitions().size() < 1) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Gets an userObject property which name is given in parameter what.
	 */
	public XMLElement get(String what) {
		return userObject.get(what);
	}

	/**
	 *
	 */
	public void set(String what, Object value) {
		userObject.set(what, value);
		return;
	}

	/**
	 *
	 */
	public String toString() {
		String toRet = ResourceManager.getLanguageDependentString("EndKey");
		if (toRet != null) {
			return toRet;
		} else {
			return "";
		}
	}

}
