/* ActivityRenderer.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：活动图形描绘类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.net.URL;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;

import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexRenderer;

import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.BPDConstants;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.xml.XMLUtil;

/**
 * Class used to display activity object.
 */
public class ActivityRenderer extends VertexRenderer {

	private BasicStroke borderStroke = new BasicStroke(2);

	protected static final int actW = BPDConfig.getInstance()
			.getActivityWidth();

	protected static final int actH = BPDConfig.getInstance()
			.getActivityHeight();

	protected static final int innerW = BPDConfig.getInstance()
			.getInnerActivityWidth();

	protected static final int innerH = BPDConfig.getInstance()
			.getInnerActivityHeight();

	protected static final int xOff = (int) ((actW - innerW) / 2);

	protected static final int yOff = (int) ((actH - innerH) / 2);

	private static String resurceImage = "Pointgenericactivity";

	/**
	 * Paints activity. Overrides super class paint to add specific painting.
	 */
	protected String getResurceImage() {
		return resurceImage;
	}

	public void paint(Graphics g) {
		// read colors because they can change on-line
		Activity act = (Activity) view.getCell();
		Color preconditionColor = Utils.getColor(BPDConfig.getInstance()
				.getActivityPreconditionColor());
		Color postconditionColor = Utils.getColor(BPDConfig.getInstance()
				.getActivityPostconditionColor());
		Color fillColor = getFillColor();

		Color gridC = graph.getGridColor();
		Color highlightC = graph.getHighlightColor();
		Color bckgC = fillColor; // graph.getBackground();
		Color borderC = bordercolor;
		if (selected) {
			bckgC = Utils.getColor(BPDConfig.getInstance()
					.getSelectedActivityColor());
		}

		URL url = ResourceManager.getResource(this.getResurceImage()
				+ BPDConstants.IMAGE_SUFFIX);
		// System.out.println("url
		// ="+url+"getResurceImage()="+getResurceImage());

		super.setBackground(bckgC);

		

		g.setColor(bckgC);
		g.fillRect(1, 0, actW - 1+10, actH - 1);
		g.setColor(bordercolor);
		((Graphics2D) g).setStroke(borderStroke);
		g.drawRect(1, 1, actW - 2+10, actH - 2);

		// if selected, or has focus draw with selection/focus attributes
		if (selected || hasFocus) {
			((Graphics2D) g).setStroke(GraphConstants.SELECTION_STROKE);
			if (hasFocus)
				g.setColor(graph.getGridColor());
			else if (selected)
				g.setColor(graph.getHighlightColor());
			g.drawRect(0, 0, actW - 1, actH - 1);
		}

		// drawing label
		Graphics gl = g.create(xOff+10, yOff, innerW, innerH);
		Rectangle labelRect = new Rectangle(new Dimension(innerW, innerH));
		super.setBounds(labelRect);
		
		graph.setGridColor(bckgC);
		graph.setHighlightColor(bckgC);
		setBorder(BorderFactory.createLineBorder(bckgC, borderWidth));
		super.paint(gl);
		
		
		setBorder(BorderFactory.createLineBorder(bordercolor, borderWidth));
		setForeground(bordercolor);
		graph.setGridColor(gridC);
		graph.setHighlightColor(highlightC);
		if (url != null) {
			ImageIcon imageIcon = new ImageIcon(url);
			Image image = imageIcon.getImage();
			ImageObserver imageObserver = imageIcon.getImageObserver();
			g.drawImage(image, xOff-3, yOff+5, innerW - 45, innerH - 12,
					imageObserver);
		}

		// filling pre/post condition rectangle if needed
		if (((Activity) view.getCell()).hasAnyPrecondition()) {
			g.setColor(preconditionColor);
			// paint bounds of preconditions
			g.fillRect(2, 2, xOff - 1, actH - 4);
		}
		if (((Activity) view.getCell()).hasAnyPostcondition()) {
			g.setColor(postconditionColor);
			// paint bounds of postconditions
			g.fillRect(innerW + xOff+10, 2, xOff - 2, actH - 4);
		}

		if (XMLUtil.isANDTypeSplitOrJoin(
				(com.ds.bpm.bpd.xml.activity.Activity) act
						.getPropertyObject(), 1)) {

			g.setColor(Color.BLACK);
			resurceImage = "Pointgenericactivity";
			// ((Graphics2D) g).setStroke(innerBorderStroke);
			g.drawOval(xOff - 26, yOff - 10, innerW - 40, innerH + 20);
			g.fillOval(xOff - 26, yOff - 10, innerW - 40, innerH + 20);
			g.setColor(Color.WHITE);
			g.drawOval(xOff - 28, yOff - 10, innerW - 40, innerH + 20);
			g.fillOval(xOff - 28, yOff - 10, innerW - 40, innerH + 20);
		}
		downPaint(g);
		
		if (XMLUtil.isANDTypeSplitOrJoin(
				(com.ds.bpm.bpd.xml.activity.Activity) act
						.getPropertyObject(), 0)) {

			URL surl = ResourceManager.getResource("PintsubflowactivityImage");
			
			if (surl != null) {
			
				ImageIcon imageIcon = new ImageIcon(surl);
				Image image = imageIcon.getImage();
				ImageObserver imageObserver = imageIcon.getImageObserver();
				g.drawImage(image, xOff + 65, yOff+27 , innerW - 50, innerH-55 ,
						imageObserver);
			}
			
			
		}
		

	}

	protected void downPaint(Graphics g) {

	}

	protected Color getFillColor() {
		return Utils.getColor(BPDConfig.getInstance().getManualActivityColor());
	}

}
