/*
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;
import java.net.Authenticator;

import javax.swing.JFrame;

import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.wfxml.DefInfos;
import com.ds.bpm.bpd.wfxml.WfXMLAuthenticator;
import com.ds.bpm.bpd.wfxml.WfXMLControlPanel;
import com.ds.bpm.bpd.wfxml.WfXMLPanel;
import com.ds.bpm.bpd.xml.NewXMLElementDialog;
import com.ds.bpm.bpd.xml.panels.NewXMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.NewXMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

public class WfXML extends ActionBase{

   public WfXML (PackageEditor editor) {
      super(editor);
   }

   public void actionPerformed(ActionEvent e) {
      DefInfos dis=new DefInfos();
      String t=ResourceManager.getLanguageDependentString("ProcessDefinitionListKey");
      dis.setLabelName(t);
      WfXMLPanel p1=new WfXMLPanel(dis);
      WfXMLControlPanel p2=new WfXMLControlPanel(dis,p1,"",false,false);
      NewXMLGroupPanel gp=new NewXMLGroupPanel(dis,new NewXMLPanel[]{
               p1,p2},"",XMLPanel.BOX_LAYOUT,
                                         true,false);

      NewXMLElementDialog d=new NewXMLElementDialog((JFrame)editor.getWindow(),
                                              ResourceManager.getLanguageDependentString("WfXMLKey"));
      Authenticator.setDefault(new WfXMLAuthenticator(d));
      d.editXMLElement(gp,false,false);
      editor.update();
   }

}

