package com.ds.bpm.bpd.actions;


import com.ds.bpm.bpd.*;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.elements.Package;
import com.ds.bpm.bpd.xml.elements.WFApplication;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.WorkflowProcesses;
import com.ds.common.JDSException;
import com.ds.common.swing.ProgressDialog;
import com.ds.common.swing.progress.Task;
import com.ds.common.swing.util.SwingWorker;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.util.Iterator;

/**
 * Class that realizes <B>SaveToServer </B> action. 保存流程到服务器操作。
 */
public class SaveToServer extends ActionBase {

    private Task task;

    private String xpdlString;

    /**
     * 将流程保存到服务器操作的构造方法
     * 
     * @param editor
     *            主界面对象
     */
    public SaveToServer(PackageEditor editor) {
	super(editor);
    }

    /**
     * 操作的具体实现方法
     * 
     * @param e
     *            操作事件
     */
    public void actionPerformed(ActionEvent e) {
	if (BPD.getInstance().isLogined()) {
	    Package pkg = BPD.getInstance().getActivedProcessEditor().getGraph().getXMLPackage();
	    // 判断保存到服务器的流程是否有应用
	    WorkflowProcesses wps = (WorkflowProcesses) pkg.get("WorkflowProcesses");
	    for (Iterator it = wps.toCollection().iterator(); it.hasNext();) {
		WorkflowProcess wp = (WorkflowProcess) it.next();
		if (wp.getAppName().equals("")) {
		    WFApplication wfApp = new WFApplication();
		    wfApp.setVisible("AccessLevel", false);
		    XMLElementDialog ed = new XMLElementDialog((JFrame) editor.getWindow(), ResourceManager.getLanguageDependentString("Process.Application.title"));
		    ed.editXMLElement(wfApp.getPanel(), true, false);
		    boolean isNotApp = false;
		    if (ed.isCanceled()) {
			isNotApp = true;
		    } else {
			String systemCode = wfApp.get("SystemCode").toValue().toString();
			if (!systemCode.equals("")) {
			    wp.reConfigApplication(wfApp, systemCode);
			} else {
			    isNotApp = true;
			}
		    }
		    if (isNotApp) {
			JOptionPane.showMessageDialog(editor.getWindow(), ResourceManager.getLanguageDependentString("MessageIsNotHaveApplication"), BPD.getAppTitle(), JOptionPane.WARNING_MESSAGE);
			return;
		    }
		}
	    }
	    
	    

	    // Package pkg =
	    // BPD.getInstance().getActivedProcessEditor().getGraph().getXMLPackage();
	    // com.ds.bpm.bpd.xml.elements.Package pkg =
	    // packageEditor.getXMLPackage();

	    xpdlString = BPD.getInstance().saveWFToString(pkg);
	    if (xpdlString != null && !xpdlString.trim().equals("")) {
		task = new SaveProcessTask();
		SwingUtilities.invokeLater(new Runnable() {

		    public void run() {
			String progressTitle = ResourceManager.getLanguageDependentString("SaveToServer.Progress.Title.Name.display");
			String progressDescription = ResourceManager.getLanguageDependentString("SaveToServer.Progress.Description.Name.display");
			String progressMessage = ResourceManager.getLanguageDependentString("SaveToServer.Progress.Message.Name.display");

			try{
				ProgressDialog progressDialog = new ProgressDialog(BPD.getInstance().getMainFrame(), progressTitle, progressDescription, progressMessage, task, 500, false);
				progressDialog.dispose();
			}catch (Throwable e){

			}

		    }
		});
		task.go();
	    }
	} else {
	    JOptionPane.showMessageDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("WarningUserIsNotLogined"), BPD.getAppTitle(), JOptionPane.WARNING_MESSAGE);
	}
    }

    class SaveProcessTask extends Task {

	public SaveProcessTask() {
	    setLengthOfTask(10);
	}

	/*
	 * @see com.ds.common.swing.progress.Task#go()
	 */
	public void go() {
	    final SwingWorker worker = new SwingWorker() {

		public Object construct() {
		    setMessage(ResourceManager.getLanguageDependentString("SaveToServer.Progress.Message.SaveProcessInfo.Name.display"));
		    // 保存成功与否的标志
		    boolean saveIsSuccess = false;
		    // 获得WebService服务器客户端对象
		    // BPDService bpdService = BPD.getInstance().getBPDService();

		    try {

			Boolean result = BPD.getInstance().getBPDService().saveProcessDefListToDB(xpdlString);

			if (result != null && !result) {
			    stop();
			    // 保存到服务器失败
			    
			    JOptionPane.showMessageDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("ErrorSaveToServerIsFailing"), BPD.getAppTitle(), JOptionPane.WARNING_MESSAGE);
			    return new Object();
			} else {
			    // 设置流程标识为保存在远端服务器

			    if   (BPD.getInstance().getActivedProcessEditor()!=null){
				 BPD.getInstance().getActivedProcessEditor().setProcessFlag(BPDConstants.PROCESS_REMOTE);
				    // 将工作流图形设置为没有改变
				    BPD.getInstance().getActivedProcessEditor().setProcessModified(false);
				    // 将保存的流程存入本地流程集合
				    Package pkg = BPD.getInstance().getActivedProcessEditor().getGraph().getXMLPackage();
				    Iterator wpCln = ((WorkflowProcesses) pkg.get("WorkflowProcesses")).toCollection().iterator();
				    if (wpCln.hasNext()) {
					WorkflowProcess wp = (WorkflowProcess) wpCln.next();
					String processDefVersionId = wp.getVersionID();
					ProcessEditor processEditor = BPD.getInstance().getActivedProcessEditor();
					// 将保存流程存入远端正在编辑的流程集合
					BPD.getInstance().getRemoteEditingProcessMap().put(processDefVersionId, processEditor);
				    }

				    // 保存到远端服务器后，缓存重新获得远程流程定义列表
				    BPD.getInstance().setRemoteProcessMap(BPD.getInstance().getRemoteProcessDefList(true));

				    // 刷新流程列表
				    MainLeftDownPanel.getInstance(editor).getPackageTreePanel().refreshPackageTreePanel();
				    MainLeftDownPanel.getInstance(editor).getRemotePackageTreePanel().refreshPackageTreePanel();
				    // 刷新界面
					if( BPD.getInstance().getActivedProcessEditor()!=null){
						BPD.getInstance().getActivedProcessEditor().valueChanged(null);
					}

			    }
			   
			}
		    } catch (JDSException re) {
			BPD.getInstance().getBPDService().handleWebServiceException(re);
			return new Object();
		    } finally {
			stop();
		    }
		    return new Object();
		}
	    };
	    worker.start();
	}

	/*
	 * @see com.ds.common.swing.progress.Task#cancel()
	 */
	public void cancel() {
	}

	/*
	 * @see com.ds.common.swing.progress.Task#complete()
	 */
	public void complete() {
	}
    }
}
