/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：粘贴的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.Point;
import java.awt.event.ActionEvent;

import javax.swing.Action;
import javax.swing.TransferHandler;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDGraphUI;
import com.ds.bpm.bpd.BPDMarqueeHandler;
import com.ds.bpm.bpd.PackageEditor;

/**
 * Class that realizes <B>pasteAt</B> action. Pastes selected cells to
 * clipboard. 粘贴操作
 */
public class PasteAt extends ActionBase {

	public PasteAt(PackageEditor pe) {
		super(pe);
	}

	public void actionPerformed(ActionEvent e) {
		BPDMarqueeHandler pemh = (BPDMarqueeHandler) BPD.getInstance()
				.getActivedProcessEditor().getGraph().getMarqueeHandler();
		Point pasteTo = pemh.getPopupPoint();
		BPDGraphUI peui = (BPDGraphUI) BPD.getInstance()
				.getActivedProcessEditor().getGraph().getUI();
		peui.setInsertionPoint(pasteTo);
		Action graphPasteAction = TransferHandler.getPasteAction();
		graphPasteAction.actionPerformed(e);
		peui.setInsertionPoint(null);
	}
}
