/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：展现BPD关于界面的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;
import java.util.MissingResourceException;

import javax.swing.JDialog;
import javax.swing.JFrame;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDAboutDialog;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ResourceManager;

/**
 * Class that realizes <B>show about</B> action.
 */
public class HelpAbout extends ActionBase {

	private JDialog aboutDlg;

	public HelpAbout(PackageEditor editor) {
		super(editor);
	}

	public void actionPerformed(ActionEvent e) {
		if (aboutDlg == null) {
			try {
				String title = ResourceManager
						.getLanguageDependentString("AboutFrameTitle");
				BPDAboutDialog.showAbout((JFrame) editor.getWindow(), title,
						BPD.getLogoIcon());
			} catch (MissingResourceException mre) {
				BPDAboutDialog.showAbout((JFrame) editor.getWindow(),
						"About Process Editor", BPD.getLogoIcon());
			}
		}
	}
}
