/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：退出的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;
import java.io.FileOutputStream;

import javax.swing.JMenuItem;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDConstants;
import com.ds.bpm.bpd.PackageEditor;

/**
 * Class that realizes <B>exit</B> action. Really lame implementation of an
 * exit command.
 */
public class Exit extends ActionBase {

	public Exit(PackageEditor editor) {
		super(editor);
	}

	public void actionPerformed(ActionEvent e) {
		if (BPD.getInstance().close()) {
			try {
				String fileList = "";
				for (int i = BPD.getInstance().getRecentFilesMenu()
						.getItemCount(); i > 0;) {
					JMenuItem mItem = ((JMenuItem) BPD.getInstance()
							.getRecentFilesMenu().getMenuComponent(--i));
					fileList += mItem.getText().substring(2);
					if (i > 0)
						fileList += "\n";
				}
				FileOutputStream fos = new FileOutputStream(
						BPDConstants.BPD_USER_HOME + BPDConstants.RFL_FILENAME);
				fos.write(fileList.getBytes("UTF8"));
				// Write to file
				fos.flush();
				fos.close();
			} catch (Exception ex) {
			}
		//	System.exit(0);
		}
	}
}
