/*
 * Created on 2004-3-28
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.elements.ProcessCfgCommission;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 流程授权Action类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-3-28 15:40:25
 * @version 1.0
 */
public class Commission extends ActionBase {

	private ProcessCfgCommission pcc;

	/**
	 * Constructs a Commission instance.
	 * 
	 * @param editor
	 */
	public Commission(AbstractEditor editor) {
		super(editor);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if (BPD.getInstance().getUserInfo() == null) {
			JOptionPane.showMessageDialog(editor.getWindow(), ResourceManager
					.getLanguageDependentString("WarningUserIsNotLogined"), BPD
					.getAppTitle(), JOptionPane.WARNING_MESSAGE);
			return;
		}
		com.ds.bpm.bpd.xml.elements.WorkflowProcess wp = (com.ds.bpm.bpd.xml.elements.WorkflowProcess) BPD
				.getInstance().getActivedProcessEditor().getGraph()
				.getPropertyObject();
		if (pcc == null) {
			pcc = new ProcessCfgCommission(wp);
		}
		if (!pcc.fromServer()) {
			JOptionPane.showMessageDialog(editor.getWindow(), ResourceManager
					.getLanguageDependentString("ErrorWhenGetCommission"), BPD
					.getAppTitle(), JOptionPane.WARNING_MESSAGE);
			return;
		}
		XMLElementDialog ed = new XMLElementDialog((JFrame) editor.getWindow(),
				pcc.toLabel());
		ed.editXMLElement(pcc.getPanel(), true, false);
		if (!ed.isCanceled()) {
			if (!pcc.toServer()) {
				JOptionPane
						.showMessageDialog(
								editor.getWindow(),
								ResourceManager
										.getLanguageDependentString("ErrorWhenSaveCommission"),
								BPD.getAppTitle(), JOptionPane.WARNING_MESSAGE);
				return;
			}
		}
	}
}
