/*
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：撤销操作处理类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd;

import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;

/**
 * Class that manages <B>undo</B> and <B>redo</B>
 */
public class UndoHandler implements UndoableEditListener {
	private AbstractEditor editor;

	protected boolean addEdits = true;

	public UndoHandler(AbstractEditor editor, boolean addEdits) {
		this.addEdits = addEdits;
		this.editor = editor;
	}

	/**
	 * Messaged when the Document has created an edit, the edit is added to
	 * <code>undo</code>, an instance of UndoManager.
	 */
	public void undoableEditHappened(UndoableEditEvent e) {
		UndoableEdit ue = e.getEdit();
		if (addEdits) {
			if (BPD.getInstance().getActivedProcessEditor() != null) {
				BPD.getInstance().getActivedProcessEditor().getUndoManager()
						.addEdit(ue);
			}
		}
		editor.getUndo().update();
		editor.getRedo().update();
	}

	public void setAddEdits(boolean addEdits) {
		this.addEdits = addEdits;
	}
}
