/* ResourceManager.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：获得资源文件配置的通用工具类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd;

import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

import com.ds.bpm.bpd.xml.XMLUtil;

/**
 * Implements the static methods that are used to implement multilanguage
 * support.
 */
public class ResourceManager {
	private static Locale defaultLocale;

	private static ResourceBundle defaultResourceBundle;

	private static Locale choosenLocale;

	private static ResourceBundle choosenResourceBundle;

	private static String EncodeString; // 字符编码字符串

	private static Properties properties = new Properties();

	// BPD界面图标目录名称
	private static String directoryName;

	private static String iconPath;

	// The path of Resource File
	private static String rsFile = BPDConstants.RESOURCE_PATH;

	private static String oldRsFile = rsFile;

	private static boolean bInvalid = true;

	private static void load() {
		if (bInvalid) {
			bInvalid = false;
			try {
				// 设置字符编码
				EncodeString = "GBK";

				// default is english
				defaultLocale = new Locale("");
				defaultResourceBundle = ResourceBundle.getBundle(rsFile,
						defaultLocale);
				

				// chose the default system settings at the start
				String startingLocale = BPDConfig.getInstance()
						.getStartingLocale();
				if (startingLocale != null && startingLocale.length() > 0) {
					if (!startingLocale.equals("default")) {
						choosenLocale = new Locale(startingLocale);
					} else {
						choosenLocale = defaultLocale;
					}
				} else {
					choosenLocale = Locale.getDefault();
				}
				if (!startingLocale.equals("default")) {
					choosenResourceBundle = ResourceBundle.getBundle(rsFile,
							choosenLocale);
				} else {
					choosenResourceBundle = defaultResourceBundle;
				}
			} catch (MissingResourceException mre) {
				System.err.println(rsFile + ".properties not found");
				System.exit(1);
			}
			try {
				URL u = ResourceManager.class
						.getClassLoader()
						.getResource(BPDConstants.RESOURCE_FILEPATH + "BPD.res");
				InputStream is = (InputStream) u.getContent();
				properties.load(is);
			} catch (Exception ex) {
			}
			XMLUtil.setDefaultResources(defaultResourceBundle);
			XMLUtil.setChoosenResources(choosenResourceBundle);
			XMLUtil.setProperties(properties);

			// 设置缺省的BPD界面图标目录名称
			directoryName = "default";
			// 设置缺省的BPD界面图标目录路径
			iconPath = BPDConstants.RESOURCE_FILEPATH + directoryName + "/";
		}
	}

	/**
	 * Gets a language dependent string from the resource bundle.
	 * <p>
	 * Resource bundle represents the <i>property file</i>. For example, if
	 * property file contains something like this:<BR>
	 * <CENTER>menubar=file edit help</CENTER> method call
	 * getLanguageDependentString("menubar") will give the string <i>file edit
	 * help</i> as a result. <BR>
	 * This method reads information from property file. If can't find desired
	 * resource, returns <b>null</b>.
	 * 
	 * @param nm
	 *            name of the resource to fetch.
	 * @return String value of named resource.
	 */
	public static String getLanguageDependentString(String nm) {
		load();
		String str;
		try {
			str = getEncodeString(choosenResourceBundle.getString(nm), true);
		} catch (MissingResourceException mre) {
			try {
				str = defaultResourceBundle.getString(nm);
			} catch (MissingResourceException mre1) {
				str = null;
			}
		}
		return str;
	}

	public static String getResourceString(String nm) {
		load();
		String str = null;
		try {
			str = properties.getProperty(nm);
		} catch (Exception ex) {
		}
		return str;
	}

	/**
	 * Gets the url from a resource string.
	 * 
	 * @param key
	 *            the string key to the url in the properties.
	 * @return the resource location.
	 * @see Class#getResource
	 */
	public static URL getResource(String key) {
		load();
		String name = iconPath + properties.getProperty(key);
		if (name != null) {
			URL url = ResourceManager.class.getClassLoader().getResource(name);
			return url;
		}
		return null;
	}

	public static void setDefault() {
		load();
		choosenResourceBundle = defaultResourceBundle;
		choosenLocale = defaultLocale;
		XMLUtil.setChoosenResources(choosenResourceBundle);
	}

	public static void setSystem() {
		load();
		choosenLocale = Locale.getDefault();
		choosenResourceBundle = ResourceBundle.getBundle(
				BPDConstants.RESOURCE_PATH, choosenLocale);
		XMLUtil.setChoosenResources(choosenResourceBundle);
	}

	/**
	 * Returns the default resource bundle.
	 */
	public static ResourceBundle getDefaultResourceBundle() {
		load();
		return defaultResourceBundle;
	}

	/**
	 * Returns the current locale.
	 */
	public static ResourceBundle getChoosenResourceBundle() {
		load();
		return choosenResourceBundle;
	}

	/**
	 * Returns the default locale.
	 */
	public static Locale getDefaultLocale() {
		return defaultLocale;
	}

	/**
	 * Returns the current locale.
	 */
	public static Locale getChoosenLocale() {
		return choosenLocale;
	}

	/**
	 * Sets the new resource and locale to be used.
	 */
	public static void setChoosen(Locale loc) throws MissingResourceException {
		load();
		Locale previousLocale = choosenLocale;
		try {
			choosenLocale = loc;
			choosenResourceBundle = ResourceBundle.getBundle(rsFile, loc);
			XMLUtil.setChoosenResources(choosenResourceBundle);
		} catch (Exception ex) {
			choosenLocale = previousLocale;
		}
	}

	/**
	 * Sets the encoding String of message
	 * 
	 * @param message
	 *            the name of string.
	 * @param isEncode
	 *            is or is not ecoding..
	 * @return encoding String value of message.
	 */
	public static String getEncodeString(String message, boolean isEncode) {
		// 返回字符串
		String str = "";
		if (isEncode) {
			// 通过字符编码后的返回字符串
			try {
				str = new String(message.getBytes("ISO8859-1"), EncodeString);
			} catch (Exception e) {
				// System.out.println("set encoding error!");
			}
		} else {
			// 不通过编码的返回字符串
			str = message;
		}
		return str;
	}

	public static void setIconPath(String directoryName) {
		iconPath = BPDConstants.RESOURCE_FILEPATH + directoryName + "/";
	}

	public static String getIconPath() {
		return iconPath;
	}

	public static void setResourceFile(String newRsFile) {
		oldRsFile = rsFile;
		rsFile = newRsFile;
		bInvalid = true;
	}

	public static void recoverResourceFile() {
		rsFile = oldRsFile;
		bInvalid = true;
	}
}
