package com.ds.bpm.bpd;

import com.ds.bpm.bpd.misc.PackageTreePanel;
import com.ds.bpm.bpd.misc.TextTreePanel;
import com.ds.bpm.bpd.xml.elements.BlockActivity;
import com.ds.bpm.bpd.xml.elements.Package;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.panels.TabbedPanel;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;

public class MainLeftDownPanel extends JPanel {

    private AbstractEditor editor;

    private static MainLeftDownPanel mcdp;

    public JTabbedPane mainLeftDownPanel;// 左下视图

    public JTabbedPane tabOverviewPanel;// 左上全图预览

    private HashMap RemoteOverViewMap;// 远程流程预览

    private HashMap LocalOverViewMap;// 本地流程预览

    private JPanel textTreePanel;// 包结构图

    private PackageTreePanel remotepackageTreePanel;

    private PackageTreePanel packageTreePanel;

    private JSplitPane splitPane;

    private JPanel emptyjPanel;

    public static MainLeftDownPanel getInstance(AbstractEditor editor) {
        if (mcdp == null) {
            mcdp = new MainLeftDownPanel(editor);
        }
        return mcdp;
    }

    public MainLeftDownPanel(AbstractEditor editor) {
        this.editor = editor;
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(200, 700));

        this.mainLeftDownPanel = this.getMainLeftDownPanel();
        this.tabOverviewPanel = this.getTabOverviewPanel();

    }

    public void refreshView() {
        // this.editor=BPD.getInstance().getActivedProcessEditor().getParentEditor();
        int k = this.mainLeftDownPanel.getSelectedIndex();
        try {
            init();
            this.add(tabOverviewPanel, BorderLayout.NORTH);
            this.add(mainLeftDownPanel, BorderLayout.CENTER);
            refreshOverview();

            this.refreshPackageView();
        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    /**
     * 初始化
     */
    private void init() {
        this.setLayout(new BorderLayout());
        mainLeftDownPanel = this.getMainLeftDownPanel();
        mainLeftDownPanel.setName(ResourceManager.getLanguageDependentString("TabOverviewPanel.Top.Name.display"));

        if (packageTreePanel == null) {
            packageTreePanel = new PackageTreePanel((PackageEditor) editor, ResourceManager.getLanguageDependentString("PackageTreePanel.LocalProcessRootNode.Top.Name.display"), false, BPDConstants.PROCESS_LOCAL);
            packageTreePanel.setName(ResourceManager.getLanguageDependentString("PackageTreePanel.LocalProcessRootNode.Top.Name.display"));
            mainLeftDownPanel.add(packageTreePanel);
        } else {
            packageTreePanel.refreshPackageTreePanel();
        }
        if (remotepackageTreePanel == null) {
            remotepackageTreePanel = new PackageTreePanel((PackageEditor) editor, ResourceManager.getLanguageDependentString("PackageTreePanel.RemoteProcessRootNode.Top.Name.display"), false, BPDConstants.PROCESS_REMOTE);
            remotepackageTreePanel.setName(ResourceManager.getLanguageDependentString("PackageTreePanel.RemoteProcessRootNode.Top.Name.display"));
            mainLeftDownPanel.add(remotepackageTreePanel);
        } else {
            remotepackageTreePanel.refreshPackageTreePanel();
        }

        // 占位主要是美观
        if (tabOverviewPanel.countComponents() == 0) {
            emptyjPanel = new JPanel();
            JLabel jLable1 = new JLabel("                                      ");
            emptyjPanel.add(jLable1);
            emptyjPanel.setName(ResourceManager.getLanguageDependentString("TabOverviewPanel.Top.Name.display"));
            tabOverviewPanel.add(emptyjPanel, ResourceManager.getLanguageDependentString("TabOverviewPanel.Top.Name.display"));

        }

        this.setAutoscrolls(true);
    }

    /**
     * 刷新全图预览
     */
    public void refreshOverview() {
        WorkflowProcess workflowProcess = null;
        String name = null;
        String workflowProcessVersionId = null;
        JPanel overviewPanel = null;
        Map overViewMap = null;

        if (BPD.getInstance().getActivedProcessEditor() instanceof ProcessEditor) {
            String processFlag = BPD.getInstance().getActivedProcessEditor().getProcessFlag();
            if (processFlag == null) {

                processFlag = BPDConstants.PROCESS_REMOTE;
            }

            if (processFlag.equals(BPDConstants.PROCESS_LOCAL)) {
                overViewMap = this.getLocalOverViewMap();
            } else if (processFlag.equals(BPDConstants.PROCESS_REMOTE)) {
                overViewMap = this.getLocalOverViewMap();
            }
            ;
            Object object = BPD.getInstance().getActivedProcessEditor().getGraph().getPropertyObject();

            if (object instanceof WorkflowProcess) {
                workflowProcess = (WorkflowProcess) object;
                name = workflowProcess.getName();
                workflowProcessVersionId = workflowProcess.getVersionID();
            }
            if (object instanceof BlockActivity) {
                BlockActivity blockActivity = (BlockActivity) object;
            }
            if (tabOverviewPanel == null) {
                this.tabOverviewPanel = new JTabbedPane(JTabbedPane.TOP);
            }
            if (!overViewMap.containsKey(workflowProcessVersionId)) {
                overviewPanel = new BPDOverviewPanel(BPD.getInstance().getActivedProcessEditor().getGraph());
                if (BPD.getInstance().getActivedProcessEditor().getProcessFlag().equals(BPDConstants.PROCESS_LOCAL)) {
                    overviewPanel.setName(ResourceManager.getLanguageDependentString("PackageTreePanel.LocalProcessRootNode.Name.display") + "-'" + name + "'");
                } else {
                    overviewPanel.setName(ResourceManager.getLanguageDependentString("PackageTreePanel.RemoteProcessRootNode.Name.display") + "-'" + name + "'");
                }
                overViewMap.put(workflowProcessVersionId, overviewPanel);
                tabOverviewPanel.add(overviewPanel);
            }
            overviewPanel = (JPanel) overViewMap.get(workflowProcessVersionId);
            tabOverviewPanel.setSelectedComponent(overviewPanel);
            if (tabOverviewPanel.countComponents() > 1 && tabOverviewPanel.getComponent(0).getName().equals(ResourceManager.getLanguageDependentString("TabOverviewPanel.Top.Name.display"))) {
                tabOverviewPanel.remove(0);
            }
            // this.remove(0);
            // this.add(tabOverviewPanel, BorderLayout.NORTH);
        }

    }

    public void refreshPackageView() {

        if (((PackageEditor) editor).getXMLPackage() == null) {
            mainLeftDownPanel.remove(textTreePanel);
            textTreePanel = TextTreePanel.getInstance(null, null, ResourceManager.getLanguageDependentString("TextTreePanel.Top.Name.display"));
            mainLeftDownPanel.add(textTreePanel, ResourceManager.getLanguageDependentString("TextTreePanel.Top.Name.display"));

        } else {
            int j = mainLeftDownPanel.getSelectedIndex();

            this.editor = BPD.getInstance().getPackageEditor();
            mainLeftDownPanel.remove(textTreePanel);
            Package xmlpackage = null;
            if (BPD.getInstance().getActivedProcessEditor() != null) {
                xmlpackage = BPD.getInstance().getPackageEditor().getXMLPackage();
                if (xmlpackage == null) {
                    xmlpackage = BPD.getInstance().getPackageEditor().getRealXMLPackage();
                }
            }
            this.textTreePanel = TextTreePanel.getInstance(xmlpackage, null, ResourceManager.getLanguageDependentString("TextTreePanel.Top.Name.display"));
            mainLeftDownPanel.add(textTreePanel, ResourceManager.getLanguageDependentString("TextTreePanel.Top.Name.display"));

            mainLeftDownPanel.setSelectedIndex(j);

        }

    }

    public PackageTreePanel getRemotePackageTreePanel() {
        // mainLeftDownPanel.setSelectedComponent(remotepackageTreePanel);
        return this.remotepackageTreePanel;

    }

    public TextTreePanel getTextTreePanel() {
        return (TextTreePanel) textTreePanel;
    }

    public PackageTreePanel getPackageTreePanel() {
        // mainLeftDownPanel.setSelectedComponent(packageTreePanel);
        return packageTreePanel;
    }

    public JTabbedPane getMainLeftDownPanel() {
        if (mainLeftDownPanel == null) {
            mainLeftDownPanel = new TabbedPanel(JTabbedPane.TOP);
            mainLeftDownPanel.setMinimumSize(new Dimension(160, 400));
            mainLeftDownPanel.addMouseListener(new MouseAdapter() {
                public void mousePressed(MouseEvent ev) {
                    if (ev.getClickCount() > 1 && !SwingUtilities.isRightMouseButton(ev)) {
                        if (BPD.getInstance().getPackageEditor().leftSplitPane.getRightComponent().isShowing()) {
                            BPD.getInstance().getPackageEditor().leftSplitPane.getRightComponent().hide();
                        } else {
                            BPD.getInstance().getPackageEditor().leftSplitPane.getRightComponent().show(true);
                            // MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).refreshOverview();
                        }
                        if (MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).getComponent(0).isShowing()) {
                            MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).getComponent(0).hide();
                        } else {
                            MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).getComponent(0).show(true);
                            // BPD.getInstance().getPackageEditor().refreshView();
                        }
                        MainLeftDownPanel mldp = MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor());
                        mldp.refreshView();
                        BPD.getInstance().getPackageEditor().leftSplitPane.setLeftComponent(mldp);

                        MainCenterDownPanel mcdp = (MainCenterDownPanel.getInstance(BPD.getInstance().getPackageEditor()));
                        mcdp.refreshView();
                        BPD.getInstance().getPackageEditor().graphMainsplitPane.setBottomComponent(mcdp);
                    }
                }
            });
        }
        return mainLeftDownPanel;
    }

    public JTabbedPane getTabOverviewPanel() {
        if (this.tabOverviewPanel == null) {
            tabOverviewPanel = new JTabbedPane(JTabbedPane.TOP);
            tabOverviewPanel.setMinimumSize(new Dimension(160, 150));
            tabOverviewPanel.addMouseListener(new MouseAdapter() {
                public void mousePressed(MouseEvent ev) {
                    if (ev.getClickCount() > 1 && !SwingUtilities.isRightMouseButton(ev)) {
                        if (BPD.getInstance().getPackageEditor().leftSplitPane.getRightComponent().isShowing()) {
                            BPD.getInstance().getPackageEditor().leftSplitPane.getRightComponent().hide();
                        } else {
                            BPD.getInstance().getPackageEditor().leftSplitPane.getRightComponent().show(true);
                            // MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).refreshOverview();
                        }
                        if (MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).getComponent(1).isShowing()) {
                            MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).getComponent(1).hide();
                        } else {
                            MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).getComponent(1).show(true);
                            // BPD.getInstance().getPackageEditor().refreshView();
                        }
                        MainLeftDownPanel mldp = MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor());
                        mldp.refreshView();
                        BPD.getInstance().getPackageEditor().leftSplitPane.setLeftComponent(mldp);

                        MainCenterDownPanel mcdp = (MainCenterDownPanel.getInstance(BPD.getInstance().getPackageEditor()));
                        mcdp.refreshView();
                        BPD.getInstance().getPackageEditor().graphMainsplitPane.setBottomComponent(mcdp);
                    }
                    if (ev.getClickCount() == 1) {
                    }
                }

                public void mouseReleased(MouseEvent ev) {
                    Point evp = ev.getPoint();
                    JTabbedPane ctbp = BPD.getInstance().getPackageEditor().contentTabbedPane;
                    Component jtp = ctbp.getComponentAt(evp);
                    if (jtp != null) {
                        // MainCenterDownPanel.getInstance(BPD.getInstance()
                        // .getPackageEditor()).mainDownTaBedPanel
                        // .add(((JTabbedPane) ev.getComponent())
                        // .getSelectedComponent());
                    }
                    // tabOverviewPanel.add(ev.getComponent());
                }
            });

        }

        return tabOverviewPanel;
    }

    public Map getRemoteOverViewMap() {
        if (this.RemoteOverViewMap == null) {
            RemoteOverViewMap = new HashMap();
        }
        return RemoteOverViewMap;
    }

    public Map getLocalOverViewMap() {
        if (this.LocalOverViewMap == null) {
            LocalOverViewMap = new HashMap();
        }
        return LocalOverViewMap;
    }

}
