/* BPDConstants.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：静态数据定义类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Stroke;

/**
 * Used to hold various static variables to be easily acessed from anywhere.
 */
public class BPDConstants {

	public static final int TYPE_OF_ELEMENT_NORMAL = 0;

	public static final int TYPE_OF_ELEMENT_STARTING = 1;

	public static final int TYPE_OF_ELEMENT_ENDING = 2;

	public static final int TYPE_OF_ELEMENT_STANDALONE = 3;
	public static final String RURL_FILENAME = "/.rurls";
	public static final int PROCESS_OFFSET = 50;

	public static final int HOW_MANY_PROCESSES_IN_ONE_ROW = 3;

	public static final double PROCESS_DISTANCE_COEFF = 1.5;

	public static final Stroke DEPARTMENT_STROKE = new BasicStroke(2);

	public static final String BPD_USER_HOME = System.getProperty("user.home")
			+ "/.BPD40";

	public static final String RFL_FILENAME = "/.rfl";

	public static final String BPD_CONF_FILENAME = "/BPD.conf";

	/** Suffix applied to the key used in resource file lookups for an path. */
	public static final String PATH_SUFFIX = "Path";

	/** Suffix applied to the key used in resource file lookups for an image. */
	public static final String IMAGE_SUFFIX = "Image";

	/** Suffix applied to the key used in resource file lookups for a label. */
	public static final String LABEL_SUFFIX = "Label";

	/** Suffix applied to the key used in resource file lookups for an action. */
	public static final String ACTION_SUFFIX = "Action";

	/** Suffix applied to the key used in resource file lookups for a submenu. */
	public static final String MENU_SUFFIX = "Menu";

	/** Suffix applied to the key used in resource file lookups for a menuitem */
	public static final String ACCEL_SUFFIX = "Accel";

	/** Suffix applied to the key used in resource file lookups for a menuitem */
	public static final String MNEMONIC_SUFFIX = "Mnemonic";

	/** Suffix applied to the key used in resource file lookups for tooltip text. */
	public static final String TIP_SUFFIX = "Tooltip";

	// Some static final String's for accessing appropriate stuff from resource
	public static final String SELECT_TOOL = "SelectTool";

	public static final String SUBFLOW_ACTIVITY_TOOL = "SubflowActivityTool";
	
	public static final String PARTICIPANT_TOOL = "OutflowActivityTool";
	
	public static final String OUTFLOW_ACTIVITY_TOOL = "OutflowActivityTool";

	public static final String BLOCK_ACTIVITY_TOOL = "BlockActivityTool";

	public static final String START_TOOL = "StartActivityTool";

	public static final String END_TOOL = "EndActivityTool";

	public static final String MANUAL_ACTIVITY_TOOL = "ManualActivityTool";

	public static final String AUTO_ACTIVITY_TOOL = "AutoActivityTool";
	public static final String AUTO_ACTIVITY_SERVICE = "ServiceActivityTool";
	public static final String AUTO_ACTIVITY_DEVICE = "DeviceActivityTool";
	public static final String AUTO_ACTIVITY_EVENT = "EventActivityTool";
	
	
	public static final String PROCESS_ACTIVITY_TOOL = "ProcessActivityTool";

	public static final String TRANSITION_TOOL = "TransitionTool";

	public static final String SELF_ROUTED_TRANSITION_TOOL = "SelfRoutedTransitionTool";

	public static final String TRANSITION_TOOL_SMALL = "TransitionToolSmall";

	public static final String SELF_ROUTED_TRANSITION_TOOL_SMALL = "SelfRoutedTransitionToolSmall";

	public static final String APPLICATION_NAME = "BPD";
	
	public static final String BPDICONPAT = "resources/default/icon.gif";

	public static final String RESOURCE_PATH = "com.ds.bpm.bpd.resources.BPD";

	public static final String RESOURCE_FILEPATH = "com/ds/bpm/bpd/resources/";

	public static final Font DEFAULTFONT = new Font("宋体", Font.PLAIN, 12);

	// 本地流程的标识
	public static final String PROCESS_LOCAL = "LOCAL";

	// 远端流程的标识
	public static final String PROCESS_REMOTE = "REMOTE";
																			// 测试中
}
