package com.ds;

import com.ds.common.util.StringUtility;

import javax.swing.*;
import java.awt.*;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;

public class PathUtil {

    public static String getJdsPath() throws MalformedURLException, IOException {
        String runningURL = (new URL(PathUtil.class.getProtectionDomain()
                .getCodeSource().getLocation(), ".")).openConnection()
                .getPermission().getName();
        runningURL = StringUtility.replace(runningURL, "/lib/", "/");
        runningURL = StringUtility.replace(runningURL, "\\lib\\", "\\");

        return runningURL;
    }


    public static String getJdsRealPath() throws MalformedURLException, IOException {
        String realPath = StringUtility.replace(PathUtil.getJdsPath(), "/bin/", "/");
        realPath = StringUtility.replace(realPath, "/lib/", "/");
        realPath = StringUtility.replace(realPath, "\\lib\\", "\\");
        realPath = StringUtility.replace(realPath, "\\bin\\", "\\");
        // System.out.println("getJdsRealPath=" + realPath);
        return realPath;
    }


    /*
     * 中文转unicode编码
     */
    public static String gbEncoding(final String gbString) {
        char[] utfBytes = gbString.toCharArray();
        String unicodeBytes = "";
        for (int i = 0; i < utfBytes.length; i++) {
            String hexB = Integer.toHexString(utfBytes[i]);
            if (hexB.length() <= 2) {
                hexB = "00" + hexB;
            }
            unicodeBytes = unicodeBytes + "\\u" + hexB;
        }
        return unicodeBytes;
    }


    public static String decodeUnicode(final String dataStr) {
        int start = 0;
        int end = 0;
        final StringBuffer buffer = new StringBuffer();
        while (start > -1) {
            end = dataStr.indexOf("\\u", start + 2);
            String charStr = "";
            if (end == -1) {
                charStr = dataStr.substring(start + 2, dataStr.length());
            } else {
                charStr = dataStr.substring(start + 2, end);
            }
            char letter = (char) Integer.parseInt(charStr, 16); // 16进制parse整形字符串。
            buffer.append(new Character(letter).toString());
            start = end;
        }
        return buffer.toString();
    }


    public static String getUtfCode(String text) {
        if (text != null) {

            try {
                text = new String(text.getBytes("ISO8859-1"), Charset.forName("utf-8"));
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }

        }
        return text;
    }


    public static Color String2Color(String str) {
        if (str == null || "".equals(str))
            return Color.BLACK;
        int i = Integer.parseInt(str, 16);
        return new Color(i);
    }

    public static ImageIcon zoomIcon(ImageIcon icon, Dimension size) {
        if (icon != null) {
            try {
                Image menuImage = icon.getImage();
                menuImage = menuImage.getScaledInstance(size.width, size.height, 1);
                icon.setImage(menuImage);
            } catch (Exception e) {
            }
        }
        return icon;
    }

    public static ImageIcon getIconImag(String icon) {
        URL imgUrl = null;
        try {
            imgUrl = new URL(icon);
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
        ImageIcon imageIcon = new ImageIcon(imgUrl);
        return imageIcon;
    }

    ;

    public static Image getThumb(String thumb) {
        URL imgUrl = null;
        try {
            imgUrl = new URL(thumb);
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
        ImageIcon imageIcon = new ImageIcon(imgUrl);
        return imageIcon.getImage();
    }
}
