package com.ds.rad;

import com.ds.common.JDSException;
import com.ds.context.JDSActionContext;
import com.ds.esd.editor.enums.CustomMenuType;
import com.ds.esd.editor.extmenu.PluginsFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping(value = "/RAD/{projectName}/")
public class RADHandler {

    @RequestMapping(value = "projectManager")
    public String projectManager(@PathVariable String projectName) {
        try {
            PluginsFactory.getInstance().getAllTopMenu(CustomMenuType.top);
        } catch (JDSException e) {
            e.printStackTrace();
        }
        JDSActionContext.getActionContext().getContext().put("projectName", projectName);
        String ftlUrl = "/sysapp/ftl/projectManager.ftl";
        return ftlUrl;
    }

}
