package com.ds.rad;

import com.ds.common.JDSConstants;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.context.JDSActionContext;
import com.ds.editor.ESDEditor;
import com.ds.editor.cmd.ESDChrome;
import com.ds.esb.config.EsbBeanAnnotation;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.dsm.DSMFactory;
import com.ds.esd.esdserver.ESDServerUtil;
import com.ds.esd.project.config.DevUserConfig;
import com.ds.esd.project.config.LocalServer;
import com.ds.server.JDSServer;
import com.ds.server.eumus.SystemStatus;
import com.ds.server.httpproxy.ServerProxyFactory;
import com.ds.server.httpproxy.core.ProxyHost;
import com.ds.web.RemoteConnectionManager;
import org.apache.http.HttpHost;
import org.openqa.selenium.chrome.ChromeDriver;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@EsbBeanAnnotation
public class ESDService {
    private static final Log logger = LogFactory.getLog(JDSConstants.CONFIG_KEY, ESDService.class);


    public ESDService() {

    }


    public void export() {
        Object projectName = JDSActionContext.getActionContext().getParams("projectName");
        ESDChrome defaultChrome = getCurrChromeDriver();
        if (projectName != null) {
            RemoteConnectionManager.getConntctionService(projectName.toString()).execute(new Runnable() {
                @Override
                public void run() {
                    exportProject(projectName.toString(), defaultChrome, false, true);
                }
            });
        }
    }

    public void startDebugServer() {
        Object projectName = JDSActionContext.getActionContext().getParams("projectName");
        ESDChrome chrome = getCurrChromeDriver();
        if (projectName != null) {
            LocalServer server = null;
            Project project = null;
            try {
                server = ESDFacrory.getESDClient().getDefaultLocalServer(projectName.toString());
                project = ESDFacrory.getESDClient().getProjectByName(projectName.toString());
            } catch (JDSException e) {
                chrome.printLog(e.getMessage(), true);
                return;
            }
            if (server == null) {
                chrome.printLog("请配置本地服务地址！", true);
                return;
            } else {
                ESDServerUtil.startESDServer(project, server);
                server.setStatus(SystemStatus.ONLINE);
            }
        }
    }

    public void stopDebugServer() {
        Object projectName = JDSActionContext.getActionContext().getParams("projectName");
        ESDChrome chrome = getCurrChromeDriver();
        if (projectName != null) {
            LocalServer server = null;
            try {
                server = ESDFacrory.getESDClient().getDefaultLocalServer(projectName.toString());
            } catch (JDSException e) {
                chrome.printLog(e.getMessage(), true);
                return;
            }
            if (server == null) {
                chrome.printLog("请配置本地服务地址！", true);
                return;
            } else {
                ESDServerUtil.stopESDServer(server);
                server.setStatus(SystemStatus.OFFLINE);
            }
        }
    }


    public void exportLocalServer() {
        Object projectName = JDSActionContext.getActionContext().getParams("projectName");
        Object serverId = JDSActionContext.getActionContext().getParams("serverId");
        ESDChrome chrome = getCurrChromeDriver();
        if (projectName != null) {
            String localServerId = null;
            if (serverId != null) {
                localServerId = serverId.toString();
            }
            String finalLocalServerId = localServerId;
            RemoteConnectionManager.getConntctionService(projectName.toString()).execute(new Runnable() {
                @Override
                public void run() {
                    try {
                        ESDFacrory.getESDClient().exportLocalServer(projectName.toString(), finalLocalServerId, chrome);
                    } catch (JDSException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void buildCustomModule(String packageName, String esdPackageName) {
        String projectName = null;
        if (JDSActionContext.getActionContext().getParams("projectName") != null) {
            projectName = JDSActionContext.getActionContext().getParams("projectName").toString();
        }
        ProjectVersion version = null;
        try {
            version = ESDFacrory.getESDClient().getProjectVersionByName(projectName);
            Map map = new HashMap();
            map.put("projectId", version.getProject().getId());
            ESDChrome chrome = getCurrChromeDriver();
            ESDFacrory.getESDClient().buildCustomModule(projectName, packageName, esdPackageName, map, chrome);

        } catch (JDSException e) {
            e.printStackTrace();
        }

    }

    public void rebuildCustomModule() {
        String projectName = null;
        if (JDSActionContext.getActionContext().getParams("projectName") != null) {
            projectName = JDSActionContext.getActionContext().getParams("projectName").toString();
        }
        ProjectVersion version = null;
        try {
            version = ESDFacrory.getESDClient().getProjectVersionByName(projectName);
            Map map = new HashMap();
            map.put("projectId", version.getProject().getId());
            ESDChrome chrome = getCurrChromeDriver();
            ESDFacrory.getESDClient().buildCustomModule(projectName, null, null, map, chrome);

        } catch (JDSException e) {
            e.printStackTrace();
        }

    }

    public void customDebug() {
        ESDChrome chrome = getCurrChromeDriver();
        String projectName = null;
        String sessionId = null;
        if (JDSActionContext.getActionContext().getParams("sessionId") != null) {
            sessionId = JDSActionContext.getActionContext().getParams("sessionId").toString();
        }
        if (JDSActionContext.getActionContext().getParams("projectName") != null) {
            projectName = JDSActionContext.getActionContext().getParams("projectName").toString();
        }

        try {
            URL rUrl = null;
            try {
                rUrl = new URL("http://custom.itjds.net/custom/" + projectName + "/Debug.Index.view");
            } catch (MalformedURLException e) {
                e.printStackTrace();
                rUrl = new URL("http://dev.itjds.net");
            }

            if (sessionId == null) {
                sessionId = JDSServer.getInstance().getAdminUser().getSessionId();
            }

            ESDEditor.getInstance().openNewWin(rUrl, sessionId);

        } catch (JDSException e) {
            e.printStackTrace();

        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    public void newprocess() {
        ESDChrome chrome = getCurrChromeDriver();
        String projectName = null;
        String sessionId = null;
        if (JDSActionContext.getActionContext().getParams("sessionId") != null) {
            sessionId = JDSActionContext.getActionContext().getParams("sessionId").toString();
        }
        if (JDSActionContext.getActionContext().getParams("projectName") != null) {
            projectName = JDSActionContext.getActionContext().getParams("projectName").toString();
        }

        try {
            URL rUrl = null;
            try {
                rUrl = new URL("http://custom.itjds.net/custom/" + projectName + "/dsm.admin.Index.view?projectId=" + ESDFacrory.getESDClient().getProjectByName(projectName).getId());
            } catch (MalformedURLException e) {
                e.printStackTrace();
                rUrl = new URL("http://dev.itjds.net");

            }

            if (sessionId == null) {
                sessionId = JDSServer.getInstance().getAdminUser().getSessionId();
            }

            ESDEditor.getInstance().openNewWin(rUrl, sessionId);

        } catch (JDSException e) {
            e.printStackTrace();

        } catch (IOException e) {
            e.printStackTrace();
        }

    }


    public void screen() throws JDSException, MalformedURLException {
        Object projectName = JDSActionContext.getActionContext().getParams("projectName");
        Object url = JDSActionContext.getActionContext().getParams("url");
    }


    public void download() {
        Object projectName = JDSActionContext.getActionContext().getParams("projectName");
        ESDChrome defaultChrome = getCurrChromeDriver();
        if (projectName != null) {
            RemoteConnectionManager.getConntctionService(projectName.toString()).execute(new Runnable() {
                @Override
                public void run() {
                    exportProject(projectName.toString(), defaultChrome, false, true);
                }
            });
        }
    }

    ;


    public void exportProject(String projectName, ESDChrome chrome, boolean deploy, boolean download) {

        try {
            ESDFacrory.getESDClient().exportProject(projectName, chrome, deploy, download);
        } catch (Exception e) {
            e.printStackTrace();

        } finally {
            chrome.execScript("xui.free('export')");
        }

    }


    public ESDChrome getCurrChromeDriver() {
        Object handleId = JDSActionContext.getActionContext().getParams("handleId");
        ChromeDriver chrome = null;
        if (handleId != null) {
            chrome = ESDEditor.getInstance().getChromeDriverById(handleId.toString());
        }
        if (chrome == null) {
            chrome = ESDEditor.getInstance().getCurrChromeDriver();
        }
        return new ESDChrome(chrome);
    }


    public String clear() {
        Object projectName = JDSActionContext.getActionContext().getParams("projectName");
        if (projectName != null) {
            try {
                Object packageName = JDSActionContext.getActionContext().getParams("packageName");
                if (packageName == null || packageName == null) {
                    packageName = "test";
                }

                DSMFactory.getInstance().compileProject(projectName.toString(), true);
                List names = Arrays.asList(new String[]{packageName.toString()});
                ESDFacrory.getESDClient().delFile(names, projectName.toString());
            } catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }

        }
        return "编译完成！";
    }


    public String reload() {
        Object projectName = JDSActionContext.getActionContext().getParams("projectName");
        if (projectName != null) {

            try {
                Object packageName = JDSActionContext.getActionContext().getParams("packageName");
                DSMFactory.getInstance().compileProject(projectName.toString(), true);
            } catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }

        }
        return "编译完成！";
    }


    public void push() {
        Object projectName = JDSActionContext.getActionContext().getParams("projectName");
        ESDChrome chrome = getCurrChromeDriver();
        chrome.printLog("正在提交，请稍后关闭浏览器！", true);
        if (projectName != null) {
            RemoteConnectionManager.getConntctionService(projectName.toString()).execute(new Runnable() {
                @Override
                public void run() {
                    ESDFacrory.getInstance().dumpCache();
                }
            });
        }


    }

    public void clearAll() {
        Object projectName = JDSActionContext.getActionContext().getParams("projectName");
        ESDChrome chrome = getCurrChromeDriver();
        chrome.printLog("正在提交，请稍后关闭浏览器！", true);
        chrome.printLog("清空后会重启刷新浏览器", true);
        if (projectName != null) {
            RemoteConnectionManager.getConntctionService(projectName.toString()).execute(new Runnable() {
                @Override
                public void run() {
                    ESDFacrory.getInstance().clearCache();
                    chrome.getChrome().navigate().refresh();

                }
            });
        }
    }


    public String pull() {

        Object projectName = JDSActionContext.getActionContext().getParams("projectName");

        ESDChrome chrome = getCurrChromeDriver();
        chrome.printLog("正在拉取，请稍后！", true);
        if (projectName == null) {
            logger.error(projectName + "must be null!");
            //chrome.printLog(projectName + "must be null!", true);
            return "projectName not fround!";
        }

        if (projectName != null) {
            RemoteConnectionManager.getConntctionService(projectName.toString()).execute(new Runnable() {
                @Override
                public void run() {

                    try {
                        ESDFacrory.getESDClient().reLoadProject(projectName.toString());
                    } catch (JDSException e) {
                        e.printStackTrace();
                    }
                    chrome.getChrome().navigate().refresh();
                    ESDFacrory.getInstance().dumpCache();
                }
            });
        }


        return "ok";
    }


    public void openProject() {
        Object newProjectName = JDSActionContext.getActionContext().getParams("newProjectName");
        String sessionId = null;
        ESDChrome chrome = getCurrChromeDriver();
        if (newProjectName == null) {
            chrome.printLog(newProjectName + "must be  null!", true);
            logger.error(newProjectName + "must be null!");
            return;
        }
        ProjectVersion version = null;
        try {
            version = ESDFacrory.getESDClient().getProjectVersionByName(newProjectName.toString());
            String serverUrl = version.getProject().getPublicServerUrl();
            String url = null;
            if (serverUrl != null) {
                url = serverUrl + "/RAD/" + version.getVersionName() + "/projectManager";
            } else {
                URL localUrl = null;
                try {
                    localUrl = new URL(chrome.getChrome().getCurrentUrl());
                    HttpHost target = new HttpHost(localUrl.getHost(), localUrl.getPort(), localUrl.getProtocol());
                    url = target.toString() + "/RAD/" + version.getVersionName() + "/projectManager";
                } catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            ESDEditor.getInstance().openNewWin(new URL(url), sessionId);
        } catch (JDSException e) {
            e.printStackTrace();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }


    }

    public void exportRemoteServer() {
        Object projectName = JDSActionContext.getActionContext().getParams("projectName");
        Object serverId = JDSActionContext.getActionContext().getParams("serverId");
        if (serverId == null) {
            serverId = "";
        }
        ESDChrome chrome = getCurrChromeDriver();
        String remoteServerId = serverId.toString();
        if (projectName != null) {
            RemoteConnectionManager.getConntctionService(projectName.toString()).execute(new Runnable() {
                @Override
                public void run() {
                    try {
                        ESDFacrory.getESDClient().exportRemoteServer(projectName.toString(), remoteServerId, chrome);
                    } catch (JDSException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }


    public void openOtherWin() {
        Object url = JDSActionContext.getActionContext().getParams("url");
        ESDChrome chrome = getCurrChromeDriver();
        String sessionId = null;
        if (url == null) {
            chrome.printLog(url + "must be  null!", true);
            logger.error(url + "must be null!");
            return;
        }
        ESDEditor.getInstance().openOtherWin(url.toString(), sessionId);

    }


    public void publicLocal() {
        Object projectName = JDSActionContext.getActionContext().getParams("projectName");
        Object className = JDSActionContext.getActionContext().getParams("className");
        Object serverId = JDSActionContext.getActionContext().getParams("serverId");
        if (serverId == null) {
            serverId = "";
        }
        String localServerId = serverId.toString();
        if (projectName != null && className != null) {
            RemoteConnectionManager.getConntctionService(projectName.toString()).execute(new Runnable() {
                @Override
                public void run() {
                    try {
                        ESDFacrory.getESDClient().publicLocal(projectName.toString(), className.toString(), localServerId, true);
                    } catch (JDSException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }


    public void publicRemote() {
        Object projectName = JDSActionContext.getActionContext().getParams("projectName");
        Object className = JDSActionContext.getActionContext().getParams("className");
        Object serverId = JDSActionContext.getActionContext().getParams("serverId");
        if (serverId == null) {
            serverId = "";
        }
        String remoteServerId = serverId.toString();
        if (projectName != null && className != null) {
            RemoteConnectionManager.getConntctionService(projectName.toString()).execute(new Runnable() {
                @Override
                public void run() {
                    try {
                        ESDFacrory.getESDClient().publicRemote(projectName.toString(), className.toString(), remoteServerId, false);
                    } catch (JDSException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }


    ;

    public void open() {
        Object url = JDSActionContext.getActionContext().getParams("url");
        ESDChrome chrome = getCurrChromeDriver();
        String projectName = null;
        String sessionId = null;
        if (url == null) {
            chrome.printLog(url + "must be  null!", true);
            logger.error(url + "must be null!");
            return;
        }

        if (JDSActionContext.getActionContext().getParams("sessionId") != null) {
            sessionId = JDSActionContext.getActionContext().getParams("sessionId").toString();
        }

        if (JDSActionContext.getActionContext().getParams("projectName") != null) {
            projectName = JDSActionContext.getActionContext().getParams("projectName").toString();
        }

        try {
            URL rUrl = null;
            try {
                if (url.toString().startsWith("/")) {
                    rUrl = new URL("http://dev.itjds.net" + url.toString());
                } else {
                    rUrl = new URL(url.toString());
                }
            } catch (MalformedURLException e) {
                e.printStackTrace();
                rUrl = new URL("http://dev.itjds.net" + url.toString());
            }
            ProxyHost proxyhost = null;
            DevUserConfig userConfig = ESDFacrory.getESDClient().getUserConfig();
            List<ProxyHost> proxyHosts = userConfig.getProxyHostByUrl(rUrl.getHost());
            if (proxyHosts.isEmpty()) {
                proxyhost = ServerProxyFactory.getInstance().createProxy(rUrl, projectName, null, null, null);
                if (sessionId != null) {
                    proxyhost.setSessionId(sessionId);
                }
                userConfig.getHosts().add(proxyhost);
                ESDFacrory.getESDClient().updateUserConfig(userConfig);
            } else {
                proxyhost = proxyHosts.get(0);
                proxyhost = ServerProxyFactory.getInstance().createProxy(proxyhost);
            }

            if (sessionId == null) {
                sessionId = proxyhost.getSessionId();
            }

            if (sessionId == null) {
                sessionId = JDSServer.getInstance().getAdminUser().getSessionId();
            }

            ESDEditor.getInstance().openNewWin(rUrl, sessionId);

        } catch (JDSException e) {
            e.printStackTrace();

        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    public void closeAllPage() {
        ESDEditor.getInstance().closeAllPage();
    }

    public void quit() {
        ESDEditor.getInstance().quit();
    }


    public void logout() {
        ESDEditor.getInstance().logout(true);
    }

}
