package com.ds.rad;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.service.BPDService;
import com.ds.common.JDSConstants;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.context.JDSActionContext;
import com.ds.editor.ESDEditor;
import com.ds.esb.config.EsbBeanAnnotation;

@EsbBeanAnnotation(expressionArr = "BPD()", id = "BPD")
public class BPDCmdService {
    private static final Log logger = LogFactory.getLog(JDSConstants.CONFIG_KEY, BPDService.class);

    public BPDCmdService() {

    }

    public void open() {
        BPD.getInstance().init(true);
        BPD.getInstance().autoLogin(ESDEditor.getInstance().getUser());
    }

    public void openProcess() {
        Object processDefVersionId = JDSActionContext.getActionContext().getParams("processDefVersionId");
        String sessionId = null;
        if (processDefVersionId == null) {
            logger.error(processDefVersionId + "mast be null!");
            return;
        }
        BPD.getInstance().openWorkflow(processDefVersionId.toString());
    }

    public void close() {
        BPD.getInstance().close();
    }


}
