package com.ds.httpproxy;


import com.ds.common.JDSException;
import com.ds.common.cache.Cache;
import com.ds.common.cache.CacheManagerFactory;
import com.ds.common.database.DBAgent;
import com.ds.common.util.StringUtility;
import com.ds.config.JDSUtil;
import com.ds.hsql.HsqlDbCacheManager;
import com.ds.httpproxy.config.*;
import com.ds.server.httpproxy.core.Server;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.net.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;


public class RemoteServerFactory {

    public static RemoteServerFactory serverFactory;
    public static final String configKey = "esd";
    public static final String expression = "$GetProxyUrl.getProxyUrl()";
    //	public static Map<String, MozillaWindow > winMap=	 new HashMap<String, MozillaWindow >();
    public static Map<String, Server> serverMap = new HashMap();

    Cache handleCache;
    Cache scriptCache;


    Cache channelScriptCache;
    Cache pagCache;
    Cache channelPageCache;
    Cache hostProxyNameCache;
    Cache hostProxyCache;
    Cache hostProxyUrlCache;


    void loadHsql() {
        if (HsqlDbCacheManager.isCacheEnabled()) {
            handleCache = HsqlDbCacheManager.getCache("handle");
            scriptCache = HsqlDbCacheManager.getCache("script");
            channelScriptCache = HsqlDbCacheManager.getCache("channelscript");
            pagCache = HsqlDbCacheManager.getCache("pagCache");
            channelPageCache = HsqlDbCacheManager.getCache("channelPageCache");
            hostProxyNameCache = HsqlDbCacheManager.getCache("hostProxyNameCache");
            hostProxyCache = HsqlDbCacheManager.getCache("hostProxyCache");

        }

    }


    public static RemoteServerFactory getInstance() {
        if (serverFactory == null) {
            serverFactory = new RemoteServerFactory();
            try {
                serverFactory.initServer();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return serverFactory;
    }

    public RemoteServerFactory() {

    }

    public RemoteHostProxy getHostProxyById(String proxyid) {
        RemoteHostProxy config = (RemoteHostProxy) this.hostProxyCache.get(proxyid);
        if (config == null) {
            config = new RemoteHostProxy(proxyid);
            this.hostProxyCache.put(proxyid, config);
            if (config.getUrl() != null) {
                this.hostProxyNameCache.put(config.getUrl(), config);
            }
        }

        return config;
    }

    public Page getPag(String url) {
        if (!url.startsWith("http")) {
            url = "http://" + url;
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        Page pag = (Page) this.pagCache.get(url);
        if (pag == null) {
            pag = new Page(url);
            this.pagCache.put(url, pag);
        }
        return pag;
    }

    public ChannelPage getChannelPag(String url) {
        if (!url.startsWith("http")) {
            url = "http://" + url;
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        ChannelPage pag = (ChannelPage) this.channelPageCache.get(url);
        if (pag == null) {
            pag = new ChannelPage(url);
            this.channelPageCache.put(url, pag);
        }
        return pag;
    }

    public ChannelScript getChannelScriptById(String id) {
        ChannelScript script = (ChannelScript) this.channelScriptCache.get(id);
        if (script == null) {
            script = new ChannelScript(id);
            this.channelScriptCache.put(id, script);
        }
        return script;
    }

    public Script getScriptById(String id) {
        Script script = (Script) this.scriptCache.get(id);
        if (script == null) {
            script = new Script(id);
            this.scriptCache.put(id, script);
        }
        return script;
    }

    public Handle getHandleById(String handleid) {
        Handle config = (Handle) this.handleCache.get(handleid);
        if (config == null) {
            config = new Handle(handleid);
            this.handleCache.put(handleid, config);
        }
        return config;
    }


    private void initServer()
            throws SQLException {

        handleCache = CacheManagerFactory.createCache("esd", "handle");
        scriptCache = CacheManagerFactory.createCache("esd", "script");
        channelScriptCache = CacheManagerFactory.createCache("esd", "channelscript");
        pagCache = CacheManagerFactory.createCache("esd", "pagCache");
        channelPageCache = CacheManagerFactory.createCache("esd", "channelPageCache");
        hostProxyNameCache = CacheManagerFactory.createCache("esd", "hostProxyNameCache");
        hostProxyCache = CacheManagerFactory.createCache("esd", "hostProxyCache");
        hostProxyUrlCache = CacheManagerFactory.createCache("esd", "hostProxyUrlCache");

        if (HsqlDbCacheManager.isCacheEnabled()) {
            loadHsql();
            Collection<RemoteHostProxy> values = hostProxyNameCache.values();
            Iterator it = values.iterator();
            for (; it.hasNext(); ) {
                RemoteHostProxy proxy = (RemoteHostProxy) it.next();
                String proxyUrl = proxy.getUrl();
                if (!serverMap.containsKey(proxyUrl)) {
                    Server server = createServer(proxy);
                    serverMap.put(proxyUrl, server);
                    try {
                        server.start();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

        } else {

            loadServerConfig();
            //loadScriptConfig();
            Iterator<String> it = hostProxyNameCache.keySet().iterator();
            for (; it.hasNext(); ) {
                String proxyUrl = it.next();
                RemoteHostProxy proxy = (RemoteHostProxy) hostProxyNameCache.get(proxyUrl);
                hostProxyUrlCache.put(proxy.getUrl(), "http://" + proxy.getLocalIp() + ":" + proxy.getPort());
                if (!serverMap.containsKey(proxyUrl)) {
                    if (proxy.getLocalIp().equals(this.getLocalIp())) {
                        Server server = createServer(proxy);
                        serverMap.put(proxyUrl, server);
                        try {
                            server.start();
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }

                }
            }

        }

    }

//    public String[] getProxy(String proxyUrl) {
//        String host = proxyUrl;
//
//        if (proxyUrl.startsWith("http://")) {
//            host = proxyUrl.substring("http://".length());
//        }
//
//        if (proxyUrl.startsWith("https://")) {
//            host = proxyUrl.substring("https://".length());
//        }
//
//        if (host.indexOf("/") > -1) {
//            host = host.split("/")[0];
//        }
//
//        return new String[]{host.split(":")[0], host.split(":")[1]};
//    }


    public String createProxy(String url, boolean isNew) {
        String host = url;
        if (url.startsWith("http://")) {
            host = url.substring("http://".length());
        }
        if (host.indexOf("/") > -1) {
            host = host.split("/")[0];
        }
        if (isNew) {
            deleteHost(host);
        }

        Server server = (Server) serverMap.get(host);
        if (server == null) {
            RemoteHostProxy proxy = (RemoteHostProxy) this.hostProxyNameCache.get(host);
            if (proxy == null) {
                proxy = new RemoteHostProxy(host);
                proxy.setLocalIp(getLocalIp());
                proxy.setPort(getLocalPort());
                proxy.setUrl(host);
                proxy.setProxyid(UUID.randomUUID().toString());
                saveDb(proxy, host);
                this.hostProxyNameCache.put(host, proxy);
            }
            server = createServer(proxy);
            try {
                server.start();
            } catch (IOException e) {
                e.printStackTrace();
            }
            serverMap.put(url, server);
        }

        String proxyHost = server.getProperty("proxyUrl");

        return StringUtility.replace(host, host, proxyHost);
    }

    public synchronized void saveDb(RemoteHostProxy proxy, String host) {
        if (!HsqlDbCacheManager.isCacheEnabled()) {

            DBAgent db = null;
            try {
                db = new DBAgent("esd");

                int rowCount = 0;

                ResultSet rs = null;

                String strSql = "select  count(*) AS DAO_ROWCOUNT from cw_urlproxy t where t.url='"
                        + host + "'";
                if (db.execute(strSql) == 1) {
                    rs = db.getQueryResult();
                    if (rs.next()) {
                        rowCount = rs.getInt("DAO_ROWCOUNT");
                    }
                }
                if (rowCount > 0) {
                    proxy.loadFromDbByName(host);
                } else {
                    proxy.setLocalIp(getLocalIp());
                    proxy.setPort(getLocalPort());
                    proxy.setUrl(host);
                    proxy.setProxyid(UUID.randomUUID().toString());
                    strSql = "insert into  cw_urlproxy (proxyid,url,localip,localport) values ( ";
                    strSql = strSql + "'" + proxy.getProxyid() + "',";
                    strSql = strSql + "'" + proxy.getUrl() + "',";
                    strSql = strSql + "'" + proxy.getLocalIp() + "',";
                    strSql = strSql + "'" + proxy.getPort() + "'";
                    strSql = strSql + ")";
                    db.execute(strSql);
                }

                this.hostProxyNameCache.put(host, proxy);
            } catch (SQLException e) {
                e.printStackTrace();
            } catch (JDSException e) {
                e.printStackTrace();
            } finally {
                db.close();
            }
        }

    }

    private void loadScriptConfig()
            throws SQLException {
        DBAgent db = null;
        try {
            db = new DBAgent("esd");
        } catch (JDSException e) {
            e.printStackTrace();
        }
        ResultSet rs = null;
        String strSql = "select t.* from cw_script t ";
        if (db.execute(strSql) == 1) {
            rs = db.getQueryResult();
            while (rs.next()) {
                Script dbscript = new Script();
                String url = rs.getString("url");
                dbscript.setUrl(url);
                String uuid = rs.getString("uuid");
                dbscript.setUuid(uuid);
                String name = rs.getString("name");
                dbscript.setName(name);

                Reader reader = rs.getCharacterStream("script");
                StringWriter writer = new StringWriter();
                try {
                    int len;
                    for (char[] buf = new char[1024]; (len = reader.read(buf)) > 0; ) {
                        writer.write(buf, 0, len);
                    }

                    writer.close();
                } catch (Exception localException) {
                }
                String script = writer.toString();

                dbscript.setScript(script);
                String userid = rs.getString("userid");
                dbscript.setUserid(userid);
                Integer scriptindex = Integer.valueOf(rs.getInt("scriptindex"));
                dbscript.setScriptindex(scriptindex);
                this.scriptCache.put(uuid, dbscript);
            }
        }

        rs.close();
        db.close();
    }

    private void loadServerConfig()
            throws SQLException {
        DBAgent db = null;
        try {
            db = new DBAgent("esd");
        } catch (JDSException e) {
            e.printStackTrace();
        }
        ResultSet rs = null;
        String strSql = "select proxyid,url,localip ,localport,proxypath from cw_urlproxy t ";
        if (db.execute(strSql) == 1) {
            rs = db.getQueryResult();
            while (rs.next()) {
                RemoteHostProxy proxy = new RemoteHostProxy();
                String proxyid = rs.getString("proxyid");
                proxy.setProxyid(proxyid);
                String url = rs.getString("url");
                proxy.setUrl(url);
                String localIp = rs.getString("localip");
                proxy.setLocalIp(localIp);
                String port = rs.getString("localport");
                proxy.setPort(port);
                String proxypath = rs.getString("proxypath");
                proxy.setProxypath(proxypath);
                this.hostProxyNameCache.put(url, proxy);
                this.hostProxyCache.put(proxyid, proxy);
            }
        }
        rs.close();
        db.close();
    }

    public synchronized void deleteHost(String url) {
        serverMap.remove(url);
        this.hostProxyNameCache.remove(url);
        DBAgent db = null;
        try {
            db = new DBAgent("esd");

            String strSql = "delete cw_urlproxy where url='" + url + "'";

            db.execute(strSql);
        } catch (JDSException e) {
            e.printStackTrace();
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            db.close();
        }
    }

    public Server getServer(RemoteHostProxy config) {
        if (!serverMap.containsKey(config.getUrl())) {
            Server server = createServer(config);
            serverMap.put(config.getUrl(), server);
        }
        return (Server) serverMap.get(config.getUrl());
    }

    private Server createServer(RemoteHostProxy config) {
        Server server = null;
        try {
            server = new Server(new String[]{"-config", JDSUtil.getJdsRealPath() + "serverproxy.properties",
                    "-http.port", config.getPort(),
                    "-textProxy.resourceMount", config.getUrl(),
                    "-dataProxy.resourceMount", config.getUrl(),
                    "-otherProxy.resourceMount", config.getUrl(),
                    "-root.resourceMount", config.getProxypath() + "/",
                    "-proxyHost", config.getUrl()});
        } catch (Exception e) {
            e.printStackTrace();
        }
        server.getConfig().setProperty("proxyUrl", "http://" + config.getLocalIp() + ":" + config.getPort());
        server.getConfig().setProperty("proxyId", config.getProxyid());

        return server;
    }

    private String getLocalIp() {
        String localIp = "127.0.0.1";
        try {
            localIp = InetAddress.getLocalHost().getHostAddress();
        } catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return localIp;
    }

    private String getLocalPort() {
        ServerSocket s = null;
        String port = "8083";
        try {
            s = new ServerSocket(0);
            port = s.getLocalPort() + "";
            s.close();
        } catch (MalformedURLException e3) {
            e3.printStackTrace();
        } catch (IOException e3) {
            e3.printStackTrace();
        }
        return port;
    }

    ;

    public String getProxyUrl(URL url) {
        String proxyUrl = url.toString();

//        if (url.getHost().equals("itjds.net")) {
////            return "http://" + getLocalIp() + ":" + ESDEditor.getInstance().getAdminServer().getProperty("http.port");
////        }
//
//        String localProxy = "http://" + getLocalIp() + ":" + ESDEditor.getInstance().getLoaclServer().getProperty("http.port");
//        Pattern rule = Pattern.compile(".*/(public|RAD|root|debug|jds)//?.*");
//        boolean ruleMatches = rule.matcher(url.getPath()).matches();
//
//        if (url.getPath().endsWith("favicon.ico") || ruleMatches) {
//            proxyUrl = localProxy;
//        } else {
//            RequestMethodBean methodBean = APIConfigFactory.getInstance().findMethodBean(url.getPath());
//            if (methodBean != null) {
//                proxyUrl = localProxy;
//            }
//        }

        //String proxyurl = url;
//        String proxyip = UserBean.getInstance().getProxyHost();
//        Integer proxyport = UserBean.getInstance().getProxyPort();
//        String localIp = getLocalIp();
//        // proxyurl = creatProxy(url, false);
//        if (!localIp.equals(proxyip)) {
//            try {
//                proxyurl = (String) hostProxyUrlCache.get(host);
//                if (proxyurl == null) {
//                    proxyurl = Request.Post("http://" + proxyip + ":" + proxyport + "/commend.mvel")
//                            .bodyForm(
//                                    Form.form()
//                                            .add("expression", expression)
//                                            .add("url", url).build()
//                            )
//                            .execute().returnContent().asString();
//                    hostProxyUrlCache.put(host, proxyurl);
//                    System.out.print(host + proxyurl);
//                }
//            } catch (Exception e) {
//                e.printStackTrace();
//            }
//        } else {
//            proxyurl = creatProxy(url, false);
//        }


        return proxyUrl;
    }
}