package com.ds.handler.custom;

import com.ds.Conts;
import com.ds.common.JDSException;
import com.ds.common.util.StringUtility;
import com.ds.config.JDSUtil;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.tool.module.EUModule;
import com.ds.jds.core.esb.EsbUtil;
import com.ds.server.JDSClientService;
import com.ds.server.JDSServer;
import com.ds.server.httpproxy.core.*;
import com.ds.template.JDSFreemarkerResult;
import com.ds.vfs.FileInfo;
import com.ds.vfs.ct.CtVfsFactory;
import com.ds.vfs.ct.CtVfsService;
import freemarker.template.TemplateException;

import java.io.*;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;


public class CustomVFSResourceHandler extends AbstractHandler implements Handler {
    private static final Logger log = Logger.getLogger(CustomVFSResourceHandler.class.getName());

    private String resourceMount;
    private String defaultResource;


    Pattern rule;

    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        this.resourceMount = RESOURCE_MOUNT_OPTION.getProperty(server, handlerName);
        this.defaultResource = DEFAULT_RESOURCE_OPTION.getProperty(server, handlerName);
        rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
        return true;
    }


    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        String path = request.getPath();
        boolean ruleMatches = rule.matcher(path).matches();
        if (!ruleMatches) {
            return false;
        }


        if (path.startsWith(getUrlPrefix())) {
            path = path.substring(1, path.length());
        }

        path = path.substring("custom/".length());
        String projectName = path;
        if (path.indexOf(getUrlPrefix()) > -1) {
            projectName = path.substring(0, path.indexOf(getUrlPrefix()));
        }


        String resource = Http.join(resourceMount, path);
        if (resource.endsWith(getUrlPrefix())) {
            resource += defaultResource;
        } else if (resource.lastIndexOf('.') < 0) {
            resource += getUrlPrefix() + defaultResource;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Loading resource: " + resource);
        }
        String mimeType = getMimeType(resource);
        File file = new File(JDSUtil.getJdsRealPath() + resource);
        InputStream is = null;

        if (file.exists()) {
            is = new FileInputStream(file);
        } else {
            // 激活下载操作
            FileInfo fileInfo = null;
            try {
                JDSClientService clientService = null;
                clientService = EsbUtil.parExpression("$JDSC", JDSClientService.class);
                if (clientService == null) {
                    clientService = JDSServer.getInstance().getAdminClient();
                }
                ESDClient client = ESDFacrory.getESDClient(clientService);
                if (path.startsWith(projectName)) {
                    path = path.substring(projectName.length());
                }
                fileInfo = client.getFileByPath(path, projectName);

                if (fileInfo == null) {
                    fileInfo = client.getFileByPath(path);
                }

                if (fileInfo == null) {
                    path = StringUtility.replace(path, ".js", ".cls");
                    fileInfo = client.getFileByPath(path, projectName);
                    if (fileInfo != null) {
                        is = fileInfo.getCurrentVersonInputStream();
                    }

                }
                if (fileInfo != null && !fileInfo.getName().endsWith(".cls")) {
                    is = fileInfo.getCurrentVersonInputStream();
                    copyStreamToFile(is, file);
                    is = new FileInputStream(file);
                }

            } catch (JDSException e) {
                e.printStackTrace();
            }

            if (is != null) {
                mimeType = Conts.getSuffixMap().get(fileInfo.getName().substring(fileInfo.getName().indexOf(".")));
                response.setMimeType(mimeType);
                response.addHeader("Content-disposition", "filename=" + new String(fileInfo.getName().getBytes("utf-8"), "ISO8859-1"));
                JDSFreemarkerResult freemarkerResult = new JDSFreemarkerResult();
                if (fileInfo.getPath().endsWith(".cls")) {
                    EUModule module = null;
                    try {
                        module = ESDFacrory.getESDClient().getModule(fileInfo.getPath(), projectName);
                    } catch (JDSException e) {
                        e.printStackTrace();
                    }
                    String json = null;
                    try {
                        json = ESDFacrory.getESDClient().genJSON(module, null).toString();
                    } catch (JDSException e) {
                        e.printStackTrace();
                    }
                    response.sendResponse(json, mimeType + ";");
                    return true;
                } else if (fileInfo.getPath().endsWith(".js")) {
                    try {
                        Writer stringWriter = freemarkerResult.doExecute(fileInfo.getCurrentVersonFileHash(), CtVfsFactory.getLocalCachePath());
                        response.setMimeType(mimeType);
                        response.sendResponse(getInputStream(stringWriter.toString(), "utf-8"), -1);
                    } catch (TemplateException e) {
                        e.printStackTrace();
                    }
                } else {
                    response.setMimeType(mimeType);
                    response.addHeader("Content-disposition", "filename=" + new String(fileInfo.getName().getBytes("utf-8"), "ISO8859-1"));
                    return true;
                }

            }
        }


        if (mimeType == null || is == null) {
            log.warning("Resource was not found or the mime type was not understood. (Found file=" + (is != null) + ") (Found mime-type=" + (mimeType != null) + ")");
            return false;
        }
        response.setMimeType(mimeType);
        response.sendResponse(is, Integer.valueOf(Long.toString(file.length())));
        return true;
    }

    ;

    public CtVfsService getVfsClient() {
        CtVfsService vfsClient = CtVfsFactory.getCtVfsService();
        return vfsClient;
    }

}
