package com.ds.handler.custom;


import com.ds.config.JDSUtil;
import com.ds.server.httpproxy.core.*;
import com.ds.server.httpproxy.handler.ResourceHandler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class CustomResourceHandler extends AbstractHandler implements Handler {
    private static final Logger log = Logger.getLogger(ResourceHandler.class.getName());

    private String resourceMount;
    private String defaultResource;
    Pattern rule;

    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        this.resourceMount = RESOURCE_MOUNT_OPTION.getProperty(server, handlerName);
        this.defaultResource = DEFAULT_RESOURCE_OPTION.getProperty(server, handlerName);
        rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
        return true;
    }

    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        String path = request.getPath();
        if (!rule.matcher(path).matches()) {
            return false;
        }

        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }

        path = path.substring("custom/".length());
        String projectName = path;
        if (path.indexOf("/") > -1) {
            projectName = path.substring(0, path.indexOf("/"));
        }


        String resource = Http.join(resourceMount, path);
        if (resource.endsWith("/")) {
            resource += defaultResource;
        } else if (resource.lastIndexOf('.') < 0) {
            resource += "/" + defaultResource;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Loading resource: " + resource);
        }
        String mimeType = getMimeType(resource);

        File file = new File(JDSUtil.getJdsRealPath() + resource);

        InputStream is = null;

        if (file.exists()) {
            is = new FileInputStream(file);
        }

        if (mimeType == null || is == null) {
            log.warning("Resource was not found or the mime type was not understood. (Found file=" + (is != null) + ") (Found mime-type=" + (mimeType != null) + ")");
            return false;
        }
        if (is != null) {
            response.setMimeType(mimeType);
            response.sendResponse(is, Integer.valueOf(Long.toString(file.length())));
            return true;
        } else {
            return false;
        }
    }


}
