package com.ds.handler;


import com.ds.Conts;
import com.ds.common.JDSException;
import com.ds.common.util.StringUtility;
import com.ds.config.JDSUtil;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.tool.module.EUModule;
import com.ds.server.httpproxy.core.*;
import com.ds.template.JDSFreemarkerResult;
import com.ds.vfs.FileInfo;
import com.ds.vfs.ct.CtVfsFactory;
import freemarker.template.TemplateException;

import java.io.*;
import java.util.regex.Pattern;

public class ReleaseHandler extends AbstractHandler implements Handler {
    ;
    Pattern rule;

    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
        return true;
    }

    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        String path = request.getPath();
        if (!rule.matcher(path).matches()) {
            return false;
        }
        String json = "{}";
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }

        if (!path.startsWith("release/")) {
            return false;
        }

        path = path.substring("release/".length());


        if (path.equals("index.html")) {
            File file = new File(JDSUtil.getJdsRealPath() + "webapp/index.html");
            InputStream is = null;
            if (file.exists()) {
                is = new FileInputStream(file);
                response.sendResponse(is, Integer.valueOf(Long.toString(file.length())));
            }
            return true;
        }

        String filePath = "debug.html";
        String projectName = path;
        if (path.indexOf("/") > -1) {
            projectName = path.substring(0, path.indexOf("/"));
            filePath = path.substring(path.indexOf("/") + 1, path.length());
        }


        // 激活下载操作
        InputStream stream = null;
        FileInfo fileInfo = null;
        try {
            ESDClient client = ESDFacrory.getESDClient(ESDFacrory.defaultSpace);
            fileInfo = client.getFileByPath(filePath, projectName);
            if (fileInfo == null) {
                filePath = StringUtility.replace(filePath, ".js", ".cls");
                fileInfo = client.getFileByPath(filePath, projectName);
            }

            if (fileInfo != null) {
                stream = fileInfo.getCurrentVersonInputStream();
            }


            if (stream != null) {
                String mimeType = Conts.getSuffixMap().get(fileInfo.getName().substring(fileInfo.getName().indexOf(".")));
                response.setMimeType(mimeType);
                response.addHeader("Content-disposition", "filename=" + new String(fileInfo.getName().getBytes("utf-8"), "ISO8859-1"));
                JDSFreemarkerResult freemarkerResult = new JDSFreemarkerResult();
                if (fileInfo.getPath().endsWith(".cls")) {
                    EUModule module = null;
                    try {
                        module = client.getModule(fileInfo.getPath(), projectName);
                    } catch (JDSException e) {
                        e.printStackTrace();
                    }
                    json = client.genJSON(module, null).toString();
                    response.sendResponse(json, mimeType + ";");
                } else if (fileInfo.getPath().endsWith(".js")) {
                    try {
                        Writer stringWriter = freemarkerResult.doExecute(fileInfo.getCurrentVersonFileHash(), CtVfsFactory.getLocalCachePath());
                        response.setMimeType(mimeType);
                        response.sendResponse(getInputStream(stringWriter.toString(), "utf-8"), -1);
                    } catch (TemplateException e) {
                        e.printStackTrace();
                    }
                } else {
                    response.addHeader("Content-Length", String.valueOf(fileInfo.getCurrentVersion().getLength()));
                    // 循环写入输出流
                    response.sendResponse(stream, fileInfo.getCurrentVersion().getLength().intValue());
                }
            }
        } catch (JDSException e) {
            e.printStackTrace();
        }
        return true;
    }

    ;

}
