package com.ds.editor.chrome.task;

import com.ds.common.util.IOUtility;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.chrome.ChromeDriver;

import java.io.File;
import java.io.IOException;

public class DelayScreen implements Runnable {


    private final Integer deploy;

    private static ChromeDriver webDriver;
    private final File file;


    public DelayScreen(ChromeDriver webDriver, File file, Integer deploy) {
        this.webDriver = webDriver;
        this.deploy = deploy;
        this.file = file;
    }

    @Override
    public void run() {

        try {
            Thread.sleep(deploy);
            File imgFile = webDriver.getScreenshotAs(OutputType.FILE);
            IOUtility.copyFile(imgFile, file);
            RobotFactory.reSetDriver(webDriver.getWindowHandle(), webDriver);
        } catch (IOException e) {
            e.printStackTrace();
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {

        }
    }

}
