package com.ds.editor.chrome;

import org.openqa.selenium.ScriptKey;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.support.events.EventFiringWebDriver;

import java.net.URL;


public class PageEditor extends ChromeDriver {

    EventFiringWebDriver eventDriver;

    public static final String loginPage = "/RAD/loading.html";


    public PageEditor(ChromeOptions options, URL url, String sessionId) {
        super(options);
        this.eventDriver = new EventFiringWebDriver(this);
        eventDriver.register(new ESDWebDriverListener());
        String lodingHtml = "";
        if (url.getPort() == -1) {
            lodingHtml = url.getProtocol() + "://" + url.getHost() + loginPage;
        } else {
            lodingHtml = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + loginPage;
        }
        eventDriver.get(lodingHtml);

        ScriptKey setHandleId = eventDriver.pin("window.handleId='" + eventDriver.getWindowHandle() + "';");
//        eventDriver.manage().deleteCookieNamed("JSESSIONID");
//        try {
//            Cookie cookie = new Cookie("JSESSIONID", sessionId);
//            eventDriver.manage().addCookie(cookie);
//        } catch (Throwable e) {
//
//        }
        eventDriver.navigate().to(url);
        eventDriver.executeScript(setHandleId);

    }


}
